/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import jp.crestmuse.cmx.amusaj.sp.HarkObject;
import jp.crestmuse.cmx.amusaj.sp.SPException;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.TimeSeriesCompatible;
import jp.crestmuse.cmx.sound.TickTimer;

public class HarkDataStreamReceiver
extends SPModule {
    ServerSocket server;
    Socket socket;
    InputStream input;
    TickTimer tt = null;

    public HarkDataStreamReceiver(int n) throws IOException {
        this.server = new ServerSocket(n);
        this.socket = this.server.accept();
        this.input = new BufferedInputStream(this.socket.getInputStream());
    }

    public void setTickTimer(TickTimer tickTimer) {
        this.tt = tickTimer;
    }

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        try {
            HarkObject harkObject = new HarkObject(this.input);
            if (this.tt != null) {
                harkObject.music_position = this.tt.getTickPosition();
            }
            timeSeriesCompatibleArray[0].add(harkObject);
        }
        catch (IOException iOException) {
            throw new SPException(iOException);
        }
    }

    public void stop() {
        try {
            System.err.println("HarkDataStreamReceiver stopped.");
            this.input.close();
            this.socket.close();
            this.server.close();
        }
        catch (IOException iOException) {
            throw new SPException(iOException);
        }
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{HarkObject.class};
    }
}

