/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiEventWithTicktime
extends MidiEvent {
    public long music_position;

    public MidiEventWithTicktime(MidiMessage midiMessage, long l, long l2) {
        super(midiMessage, l);
        this.music_position = l2;
    }

    public byte[] getMessageInByteArray() {
        return this.getMessage().getMessage();
    }

    public int status() {
        return this.getMessage().getStatus() & 0xF0;
    }

    public int channel() {
        return this.getMessage().getStatus() & 0xF;
    }

    public boolean hasData1() {
        return this.getMessage().getMessage().length >= 2;
    }

    public int data1() {
        return this.getMessage().getMessage()[1];
    }

    public boolean hasData2() {
        return this.getMessage().getMessage().length >= 3;
    }

    public int data2() {
        return this.getMessage().getMessage()[2];
    }

    public static MidiEventWithTicktime createShortMessageEvent(byte[] byArray, long l, long l2) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(byArray[0], byArray[1], byArray[2]);
            return new MidiEventWithTicktime(shortMessage, l, l2);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new IllegalArgumentException("Invalid value for MIDI");
        }
    }

    public static MidiEventWithTicktime createShortMessageEvent(List<? extends Number> list, long l, long l2) {
        int n = list.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = list.get(i).byteValue();
        }
        return MidiEventWithTicktime.createShortMessageEvent(byArray, l, l2);
    }

    public static MidiEventWithTicktime createNoteOnEvent(long l, int n, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(144 + n, n2, n3);
            return new MidiEventWithTicktime(shortMessage, 0L, l);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new IllegalArgumentException("Invalid value for MIDI");
        }
    }

    public static MidiEventWithTicktime createNoteOffEvent(long l, int n, int n2, int n3) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(128 + n, n2, n3);
            return new MidiEventWithTicktime(shortMessage, 0L, l);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new IllegalArgumentException("Invalid value for MIDI");
        }
    }

    public static MidiEventWithTicktime createShortMessageEvent(long l, int n, int n2, int n3, int n4) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(n2 + n, n3, n4);
            return new MidiEventWithTicktime(shortMessage, 0L, l);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new IllegalArgumentException("Invalid value for MIDI");
        }
    }

    public static MidiEventWithTicktime createControlChangeEvent(long l, int n, int n2, int n3) {
        return MidiEventWithTicktime.createShortMessageEvent(l, n, 176, n2, n3);
    }

    public static MidiEventWithTicktime createProgramChangeEvent(long l, int n, int n2) {
        return MidiEventWithTicktime.createShortMessageEvent(l, n, 224, n2, 0);
    }
}

