/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import java.util.List;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.CSVWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyCSVTempoDeviation
extends CMXCommand<DeviationInstanceWrapper, DeviationInstanceWrapper> {
    private String csvfilename = null;
    private double tempo = 0.0;

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-csv")) {
            this.csvfilename = string2;
            return true;
        }
        if (string.equals("-tempo")) {
            this.tempo = Double.parseDouble(string2);
            return true;
        }
        return false;
    }

    @Override
    protected DeviationInstanceWrapper run(DeviationInstanceWrapper deviationInstanceWrapper) throws IOException {
        DeviationDataSet deviationDataSet = deviationInstanceWrapper.toDeviationDataSet();
        if (this.tempo > 0.0) {
            int n = deviationInstanceWrapper.getTargetMusicXML().getPartList()[0].firstMeasureNumber();
            deviationDataSet.addNonPartwiseControl(n, 1.0, "tempo", this.tempo);
        }
        CSVWrapper cSVWrapper = new CSVWrapper(this.csvfilename);
        for (List<String> list : cSVWrapper) {
            deviationDataSet.addNonPartwiseControl(Integer.parseInt(list.get(0)), Double.parseDouble(list.get(1)), "tempo-deviation", Double.parseDouble(list.get(2)));
        }
        return deviationDataSet.toWrapper();
    }

    public static void main(String[] stringArray) {
        ApplyCSVTempoDeviation applyCSVTempoDeviation = new ApplyCSVTempoDeviation();
        try {
            applyCSVTempoDeviation.start(stringArray);
        }
        catch (Exception exception) {
            applyCSVTempoDeviation.showErrorMessage(exception);
            System.exit(1);
        }
    }

    static {
        ApplyCSVTempoDeviation.addOptionHelpMessage("-csv <filename>", "");
        ApplyCSVTempoDeviation.addOptionHelpMessage("-tempo <tempo>", "");
    }
}

