/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyDeviationInstance
extends CMXCommand<DeviationInstanceWrapper, SCCXMLWrapper> {
    private int ticksPerBeat = 480;
    private boolean scc = false;
    private String smffilename = null;
    private String targetMusicXMLFileName = null;

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-smf")) {
            this.smffilename = string2;
            return true;
        }
        if (string.equals("-division")) {
            this.ticksPerBeat = Integer.parseInt(string2);
            return false;
        }
        if (string.equals("-target")) {
            this.targetMusicXMLFileName = string2;
            return true;
        }
        return false;
    }

    @Override
    protected boolean setBoolOptionsLocal(String string) {
        if (string.equals("-scc")) {
            this.scc = true;
            return true;
        }
        return false;
    }

    @Override
    public void init(CMXFileWrapper cMXFileWrapper) {
        if (cMXFileWrapper instanceof DeviationInstanceWrapper && this.targetMusicXMLFileName != null) {
            ((DeviationInstanceWrapper)cMXFileWrapper).setTargetMusicXMLFileName(this.targetMusicXMLFileName);
        }
    }

    @Override
    protected SCCXMLWrapper run(DeviationInstanceWrapper deviationInstanceWrapper) throws IOException, ParserConfigurationException, TransformerException, SAXException, InvalidFileTypeException {
        SCCXMLWrapper sCCXMLWrapper = deviationInstanceWrapper.toSCCXML(this.ticksPerBeat);
        if (this.smffilename != null && !this.smffilename.equals("")) {
            sCCXMLWrapper.toMIDIXML().writefileAsSMF(this.smffilename);
        }
        return sCCXMLWrapper;
    }

    public static void main(String[] stringArray) {
        ApplyDeviationInstance applyDeviationInstance = new ApplyDeviationInstance();
        try {
            applyDeviationInstance.start(stringArray);
        }
        catch (Exception exception) {
            applyDeviationInstance.showErrorMessage(exception);
            System.exit(1);
        }
    }

    static {
        ApplyDeviationInstance.addOptionHelpMessage("-smf <filename>", "standard MIDI file to be output");
        ApplyDeviationInstance.addOptionHelpMessage("-target <filename>", "target MusicXML file");
    }
}

