/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import groovy.lang.Closure;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.elements.MutableNote;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidElementException;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.filewrappers.SCC;
import jp.crestmuse.cmx.filewrappers.SCCDataSet;
import jp.crestmuse.cmx.filewrappers.SCCUtils;
import jp.crestmuse.cmx.filewrappers.XMLException;
import jp.crestmuse.cmx.handlers.SCCHandler;
import jp.crestmuse.cmx.handlers.SCCHandlerAdapter;
import jp.crestmuse.cmx.misc.MIDIEventList;
import jp.crestmuse.cmx.misc.ProgramBugException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCCXMLWrapper
extends CMXFileWrapper
implements SCC {
    public static final String TOP_TAG = "scc";
    private int division = 0;
    private Part[] partlist = null;
    private HeaderElement[] headlist = null;
    private Annotation[] annotations = null;
    private boolean headerStarted = false;
    private boolean partStarted = false;
    private boolean annotationsStarted = false;
    private Map<NumberedNote, MusicXMLWrapper.Note> notemap = new HashMap<NumberedNote, MusicXMLWrapper.Note>();
    private Map<NumberedNote, Byte> nEqualNotes = new HashMap<NumberedNote, Byte>();
    private Map<MutableNote, Note> notemap2 = new HashMap<MutableNote, Note>();
    private int currentPart = 0;

    @Override
    protected void analyze() {
        try {
            final HeaderElement[] headerElementArray = this.getHeaderElementList();
            final int n = this.getDivision();
            this.processNotes(new SCCHandlerAdapter(){
                private double currentInSec;
                private int lastTempoChangeInTick;
                private double lastTempoChangeInSec;
                private double currentTempo;
                private int nextTempoChangeInTick;
                private double nextTempoChangeInSec;
                private double nextTempo;
                private int nextHeader;

                public void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper) {
                    this.currentInSec = 0.0;
                    this.lastTempoChangeInTick = 0;
                    this.lastTempoChangeInSec = 0.0;
                    this.currentTempo = 120.0;
                    this.nextTempoChangeInTick = -1;
                    this.nextHeader = 0;
                    this.searchNextTempo();
                }

                public void processNote(Note note, SCCXMLWrapper sCCXMLWrapper) {
                    if (this.nextTempoChangeInTick >= 0 && this.nextTempoChangeInTick < note.onset()) {
                        this.lastTempoChangeInTick = this.nextTempoChangeInTick;
                        this.lastTempoChangeInSec = this.nextTempoChangeInSec;
                        this.currentTempo = this.nextTempo;
                        this.searchNextTempo();
                    }
                    note.onsetInMSec = (int)(1000.0 * this.calcSec(note.onset()));
                    if (this.nextTempoChangeInTick >= 0 && this.nextTempoChangeInTick < note.offset()) {
                        this.lastTempoChangeInTick = this.nextTempoChangeInTick;
                        this.lastTempoChangeInSec = this.nextTempoChangeInSec;
                        this.currentTempo = this.nextTempo;
                        this.searchNextTempo();
                    }
                    note.offsetInMSec = (int)(1000.0 * this.calcSec(note.offset()));
                }

                private void searchNextTempo() {
                    int n2;
                    for (n2 = this.nextHeader; n2 < headerElementArray.length; ++n2) {
                        if (!headerElementArray[n2].name().equals("TEMPO")) continue;
                        this.nextTempoChangeInTick = headerElementArray[n2].time();
                        this.nextTempoChangeInSec = this.calcSec(this.nextTempoChangeInTick);
                        this.nextTempo = Double.parseDouble(headerElementArray[n2].content());
                        break;
                    }
                    this.nextHeader = n2 + 1;
                }

                private double calcSec(int n2) {
                    return (double)((n2 - this.lastTempoChangeInTick) * 60) / ((double)n * this.currentTempo) + this.lastTempoChangeInSec;
                }
            });
        }
        catch (TransformerException transformerException) {
            throw new XMLException(transformerException);
        }
    }

    @Override
    public int getDivision() {
        if (this.division == 0) {
            this.division = NodeInterface.getAttributeInt(this.getDocument().getDocumentElement(), "division");
        }
        return this.division;
    }

    @Deprecated
    public void setDivision(int n) {
        this.getDocument().getDocumentElement().setAttribute("division", String.valueOf(n));
        this.division = n;
    }

    @Deprecated
    public void beginHeader() {
        this.checkElementAddition(!this.headerStarted);
        this.addChild("header");
        this.headerStarted = true;
    }

    @Deprecated
    public void addHeaderElement(int n, String string, String string2) {
        this.checkElementAddition(this.headerStarted);
        this.addChild("meta");
        this.setAttribute("name", string);
        this.setAttribute("content", string2);
        this.setAttribute("time", n);
        this.returnToParent();
    }

    @Deprecated
    public void addHeaderElement(int n, String string, double d) {
        this.addHeaderElement(n, string, String.valueOf(d));
    }

    @Deprecated
    public void addHeaderElement(int n, String string, int n2) {
        this.addHeaderElement(n, string, String.valueOf(n2));
    }

    @Deprecated
    public void endHeader() {
        this.checkElementAddition(this.headerStarted);
        this.returnToParent();
        this.headerStarted = false;
    }

    @Deprecated
    public void newPart(int n, int n2, int n3, int n4) {
        this.newPart(n, n2, n3, n4, null);
    }

    @Deprecated
    public void newPart(int n, int n2, int n3, int n4, String string) {
        this.checkElementAddition(!this.partStarted);
        this.addChild("part");
        this.setAttribute("serial", n);
        this.setAttribute("ch", n2);
        this.setAttribute("pn", n3);
        this.setAttribute("vol", n4);
        if (string != null) {
            this.setAttribute("name", string);
        }
        this.currentPart = n;
        this.partStarted = true;
    }

    @Deprecated
    public void endPart() {
        this.checkElementAddition(this.partStarted);
        this.returnToParent();
        this.partStarted = false;
    }

    @Override
    public void eachnote(Closure closure) throws TransformerException {
        SCCUtils.eachnote(this, closure);
    }

    @Override
    public void eachpart(Closure closure) throws TransformerException {
        SCCUtils.eachpart(this, closure);
    }

    @Override
    public void eachchord(Closure closure) throws TransformerException {
        SCCUtils.eachchord(this, closure);
    }

    public void eachbarline(Closure closure) throws TransformerException {
        SCCUtils.eachbarline(this, closure);
    }

    @Deprecated
    public void addPitchBend(int n, int n2) {
        this.checkElementAddition(this.partStarted);
        this.addChild("pitch-bend");
        this.addText(n + " " + n + " " + n2);
        this.returnToParent();
    }

    @Deprecated
    public void addPitchBend(int n, int n2, int n3) {
        this.checkElementAddition(this.partStarted);
        this.addChild("pitch-bend");
        this.addText(n + " " + n2 + " " + n3);
        this.returnToParent();
    }

    @Deprecated
    public void addControlChange(int n, int n2, int n3) {
        this.checkElementAddition(this.partStarted);
        this.addChild("control");
        this.addText(n + " " + n + " " + n2 + " " + n3);
        this.returnToParent();
    }

    @Deprecated
    public void addControlChange(int n, int n2, int n3, int n4) {
        this.checkElementAddition(this.partStarted);
        this.addChild("control");
        this.addText(n + " " + n2 + " " + n3 + " " + n4);
        this.returnToParent();
    }

    @Deprecated
    public void addNoteElement(int n, int n2, int n3, int n4) {
        this.addNoteElement(n, n2, n3, n4, n4);
    }

    public void addNoteElement(int n, int n2, int n3, int n4, MusicXMLWrapper.Note note) {
        this.checkElementAddition(this.partStarted);
        this.addChild("note");
        this.addText(n + " " + n2 + " " + n3 + " " + n4);
        if (note != null) {
            this.putNoteMap(n, n2, n3, n4, n4, this.getDivision(), this.currentPart, note);
        }
        this.returnToParent();
    }

    @Deprecated
    public void addNoteElement(int n, int n2, int n3, int n4, int n5) {
        this.addNoteElement(n, n2, n3, n4, n5, null);
    }

    @Deprecated
    public void addNoteElement(int n, int n2, int n3, int n4, int n5, Map<String, String> map) {
        this.addNoteElement(n, n2, n3, n4, n5, map, null);
    }

    @Deprecated
    public void addNoteElement(int n, int n2, int n3, int n4, int n5, Map<String, String> map, MusicXMLWrapper.Note note) {
        this.checkElementAddition(this.partStarted);
        this.addChild("note");
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        if (note != null) {
            this.setAttribute("voice", note.voice());
        }
        this.addText(n + " " + n2 + " " + n3 + " " + n4 + " " + n5);
        if (note != null) {
            this.putNoteMap(n, n2, n3, n4, n5, this.getDivision(), this.currentPart, note);
        }
        this.returnToParent();
    }

    @Deprecated
    public void addNoteElementWithWord(String string, int n, int n2, int n3, int n4, int n5) {
        this.checkElementAddition(this.partStarted);
        this.addChild("note");
        this.setAttribute("word", string);
        this.addText(n + " " + n2 + " " + n3 + " " + n4 + " " + n5);
        this.returnToParent();
    }

    private void putNoteMap(int n, int n2, int n3, int n4, int n5, int n6, int n7, MusicXMLWrapper.Note note) {
        NumberedNote numberedNote = new NumberedNote(n, n2, n3, n4, n5, n6, n7);
        if (this.nEqualNotes.containsKey(numberedNote)) {
            byte by = this.nEqualNotes.get(numberedNote);
            NumberedNote numberedNote2 = new NumberedNote(numberedNote);
            by = (byte)(by + 1);
            numberedNote2.number = by;
            this.notemap.put(numberedNote2, note);
            this.nEqualNotes.put(numberedNote, by);
            this.setAttribute("number", by);
        } else {
            this.notemap.put(numberedNote, note);
            this.nEqualNotes.put(numberedNote, (byte)1);
        }
    }

    @Deprecated
    public void beginAnnotations() {
        this.addChild("annotations");
        this.annotationsStarted = true;
    }

    @Deprecated
    public void addAnnotation(String string, int n, int n2, String string2) {
        this.checkElementAddition(this.annotationsStarted);
        this.addChildAndText(string, n + " " + n2 + " " + (string2 == null ? "" : string2));
    }

    @Deprecated
    public void addChord(int n, int n2, String string) {
        this.addAnnotation("chord", n, n2, string);
    }

    @Deprecated
    public void addBarline(int n, String string) {
        this.addAnnotation("barline", n, n, string);
    }

    @Deprecated
    public void endAnnotations() {
        this.checkElementAddition(this.annotationsStarted);
        this.returnToParent();
        this.annotationsStarted = false;
    }

    public Annotation[] getAnnotationList() {
        if (this.annotations != null) {
            return this.annotations;
        }
        Node node = this.selectSingleNode("/scc/annotations");
        if (node == null) {
            this.annotations = new Annotation[0];
        } else {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            this.annotations = new Annotation[n];
            for (int i = 0; i < n; ++i) {
                this.annotations[i] = new Annotation(nodeList.item(i));
            }
        }
        return this.annotations;
    }

    @Override
    public SCC.Annotation[] getChordList() {
        return SCCUtils.getChordList(this);
    }

    @Override
    public SCC.Annotation[] getBarlineList() {
        return SCCUtils.getBarlineList(this);
    }

    public HeaderElement[] getHeaderElementList() {
        if (this.headlist == null) {
            Node node = this.selectSingleNode("/scc/header");
            if (node == null) {
                this.headlist = new HeaderElement[0];
            } else {
                NodeList nodeList = this.selectNodeList(node, "meta");
                int n = nodeList.getLength();
                this.headlist = new HeaderElement[n];
                for (int i = 0; i < n; ++i) {
                    this.headlist[i] = new HeaderElement(nodeList.item(i));
                }
            }
        }
        return this.headlist;
    }

    /*
     * WARNING - void declaration
     */
    public void processNotes(SCCHandler sCCHandler) throws TransformerException {
        void var6_9;
        HeaderElement[] headerElementArray = this.getHeaderElementList();
        if (headerElementArray != null) {
            sCCHandler.beginHeader(this);
            for (NodeInterface nodeInterface : headerElementArray) {
                sCCHandler.processHeaderElement(((HeaderElement)nodeInterface).time(), ((HeaderElement)nodeInterface).name(), ((HeaderElement)nodeInterface).content(), this);
            }
            sCCHandler.endHeader(this);
        }
        NodeInterface[] nodeInterfaceArray = this.getPartList();
        Part[] partArray = nodeInterfaceArray;
        int n = partArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            Note[] noteArray;
            Part part = partArray[var6_9];
            sCCHandler.beginPart(part, this);
            for (Note note : noteArray = part.getNoteList()) {
                sCCHandler.processNote(note, this);
            }
            sCCHandler.endPart(part, this);
            ++var6_9;
        }
    }

    public void processSortedNotes(SCCHandler sCCHandler) throws TransformerException {
        Object object;
        Object object2;
        Node node = this.selectSingleNode("/scc/header");
        if (node != null) {
            sCCHandler.beginHeader(this);
            object2 = this.selectNodeList(node, "meta");
            int n = object2.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = object2.item(i);
                Object object3 = NodeInterface.getAttribute(node2, "name");
                object = NodeInterface.getAttribute(node2, "content");
                int n2 = NodeInterface.getAttributeInt(node2, "time");
                sCCHandler.processHeaderElement(n2, (String)object3, (String)object, this);
            }
            sCCHandler.endHeader(this);
        }
        object2 = this.getPartList();
        for (Object object3 : object2) {
            sCCHandler.beginPart((Part)object3, this);
            for (Note note : object = ((Part)object3).getSortedNoteList()) {
                sCCHandler.processNote(note, this);
            }
            sCCHandler.endPart((Part)object3, this);
        }
    }

    public Part[] getPartList() throws TransformerException {
        if (this.partlist == null) {
            NodeList nodeList = this.selectNodeList("/scc/part");
            int n = nodeList.getLength();
            this.partlist = new Part[n];
            for (int i = 0; i < n; ++i) {
                this.partlist[i] = new Part(nodeList.item(i));
                this.partlist[i].xpath = "/scc/part[" + i + "]";
            }
        }
        return this.partlist;
    }

    public InputStream getMIDIInputStream() throws IOException, TransformerException, ParserConfigurationException, SAXException {
        return this.toMIDIXML().getMIDIInputStream();
    }

    public MIDIXMLWrapper toMIDIXML() {
        try {
            MIDIXMLWrapper mIDIXMLWrapper = (MIDIXMLWrapper)CMXFileWrapper.createDocument("MIDIFile");
            this.toMIDIXML(mIDIXMLWrapper);
            return mIDIXMLWrapper;
        }
        catch (TransformerException transformerException) {
            throw new XMLException(transformerException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new XMLException(sAXException);
        }
        catch (InvalidFileTypeException invalidFileTypeException) {
            throw new ProgramBugException(invalidFileTypeException.toString());
        }
    }

    public void toMIDIXML(final MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, TransformerException, SAXException {
        mIDIXMLWrapper.addElementsFirstForFormat1(this.getPartList().length + 1, this.getDivision());
        this.processNotes(new SCCHandler(){
            private int currentTrack = 1;
            private int currentTime = 0;

            public final void beginHeader(SCCXMLWrapper sCCXMLWrapper) {
                mIDIXMLWrapper.newTrack(this.currentTrack);
            }

            public final void endHeader(SCCXMLWrapper sCCXMLWrapper) {
                mIDIXMLWrapper.endTrack();
                ++this.currentTrack;
            }

            public final void processHeaderElement(int n, String string, String string2, SCCXMLWrapper sCCXMLWrapper) {
                if (string.equals("TEMPO")) {
                    mIDIXMLWrapper.addMetaEvent("SetTempo", n - this.currentTime, (int)(6.0E7 / Double.parseDouble(string2)));
                } else if (string.equals("KEY")) {
                    String[] stringArray = string2.trim().split(" ");
                    mIDIXMLWrapper.addMetaEvent("KeySignature", n - this.currentTime, Integer.parseInt(stringArray[0]), stringArray[1].toLowerCase().startsWith("min") ? 1 : 0);
                }
                this.currentTime = n;
            }

            public final void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper) {
                if (part.channel() < 1 || part.channel() > 16) {
                    throw new InvalidElementException("Channel should be between 1 and 16.");
                }
                mIDIXMLWrapper.newTrack(this.currentTrack);
                MIDIEventList mIDIEventList = part.toMIDIEventList();
                mIDIXMLWrapper.addMIDIChannelMessages(mIDIEventList);
            }

            public final void endPart(Part part, SCCXMLWrapper sCCXMLWrapper) {
                mIDIXMLWrapper.endTrack();
                ++this.currentTrack;
            }

            public final void processNote(Note note, SCCXMLWrapper sCCXMLWrapper) {
            }
        });
        try {
            mIDIXMLWrapper.finalizeDocument();
        }
        catch (IOException iOException) {
            throw new ProgramBugException(iOException.toString());
        }
    }

    @Deprecated
    public SCCXMLWrapper replaceVelocity(List<List<Byte>> list, boolean bl) throws TransformerException, InvalidFileTypeException, ParserConfigurationException, SAXException, IOException {
        final SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument(TOP_TAG);
        sCCXMLWrapper.setDivision(this.getDivision());
        final Iterator<List<Byte>> iterator = list.iterator();
        SCCHandler sCCHandler = new SCCHandler(){
            Iterator<Byte> it2;

            public final void beginHeader(SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.beginHeader();
            }

            public final void endHeader(SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.endHeader();
            }

            public final void processHeaderElement(int n, String string, String string2, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.addHeaderElement(n, string, string2);
            }

            public final void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.newPart(part.serial(), part.channel(), part.prognum(), part.volume());
                this.it2 = ((List)iterator.next()).iterator();
            }

            public final void endPart(Part part, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.endPart();
            }

            public final void processNote(Note note, SCCXMLWrapper sCCXMLWrapper2) {
                if (note instanceof ControlChange) {
                    ControlChange controlChange = (ControlChange)note;
                    sCCXMLWrapper.addControlChange(controlChange.onset(), controlChange.offset(), controlChange.ctrlnum(), controlChange.value());
                } else {
                    byte by = this.it2.next();
                    sCCXMLWrapper.addNoteElement(note.onset(), note.offset(), note.notenum(), by, by, note.getAttributes(), note.getMusicXMLWrapperNote());
                }
            }
        };
        if (bl) {
            this.processSortedNotes(sCCHandler);
        } else {
            this.processNotes(sCCHandler);
        }
        sCCXMLWrapper.finalizeDocument();
        return sCCXMLWrapper;
    }

    public SCCXMLWrapper changeVelocity(List<List<Byte>> list, boolean bl) throws TransformerException, InvalidFileTypeException, ParserConfigurationException, SAXException, IOException {
        final SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument(TOP_TAG);
        sCCXMLWrapper.setDivision(this.getDivision());
        final Iterator<List<Byte>> iterator = list.iterator();
        SCCHandler sCCHandler = new SCCHandler(){
            Iterator<Byte> it2;

            public final void beginHeader(SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.beginHeader();
            }

            public final void endHeader(SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.endHeader();
            }

            public final void processHeaderElement(int n, String string, String string2, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.addHeaderElement(n, string, string2);
            }

            public final void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.newPart(part.serial(), part.channel(), part.prognum(), part.volume());
                this.it2 = ((List)iterator.next()).iterator();
            }

            public final void endPart(Part part, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.endPart();
            }

            public final void processNote(Note note, SCCXMLWrapper sCCXMLWrapper2) {
                if (note instanceof ControlChange) {
                    ControlChange controlChange = (ControlChange)note;
                    sCCXMLWrapper.addControlChange(controlChange.onset(), controlChange.offset(), controlChange.ctrlnum(), controlChange.value());
                } else {
                    byte by = this.it2.next();
                    int n = Math.max(Math.min(note.velocity + by, 127), 0);
                    sCCXMLWrapper.addNoteElement(note.onset(), note.offset(), note.notenum(), n, n, note.getAttributes(), note.getMusicXMLWrapperNote());
                }
            }
        };
        if (bl) {
            this.processSortedNotes(sCCHandler);
        } else {
            this.processNotes(sCCHandler);
        }
        sCCXMLWrapper.finalizeDocument();
        return sCCXMLWrapper;
    }

    @Override
    public SCCXMLWrapper toWrapper() {
        return this;
    }

    @Override
    public SCCDataSet toDataSet() throws TransformerException {
        int n = this.getDivision();
        SCCDataSet sCCDataSet = new SCCDataSet(n);
        HeaderElement[] headerElementArray = this.getHeaderElementList();
        NodeInterface[] nodeInterfaceArray = headerElementArray;
        int n2 = nodeInterfaceArray.length;
        for (int i = 0; i < n2; ++i) {
            HeaderElement headerElement = nodeInterfaceArray[i];
            sCCDataSet.addHeaderElement(headerElement.time(), headerElement.name(), headerElement.content());
        }
        for (NodeInterface nodeInterface : nodeInterfaceArray = this.getPartList()) {
            Note[] noteArray;
            SCCDataSet.Part object = sCCDataSet.addPart(((Part)nodeInterface).serial(), (int)((Part)nodeInterface).channel(), ((Part)nodeInterface).prognum(), ((Part)nodeInterface).volume(), ((Part)nodeInterface).name());
            for (Note note : noteArray = ((Part)nodeInterface).getNoteList()) {
                Note note2;
                if (note instanceof ControlChange) {
                    note2 = (ControlChange)note;
                    object.addControlChange(note2.onset(n), ((ControlChange)note2).ctrlnum(), ((ControlChange)note2).value());
                    continue;
                }
                if (note instanceof PitchBend) {
                    note2 = (PitchBend)note;
                    object.addPitchBend(note2.onset(), ((PitchBend)note2).value());
                    continue;
                }
                object.addNoteElement(note.onset(n), note.offset(n), note.notenum(), note.velocity(), note.offVelocity(), note.getAttributes());
            }
        }
        NodeInterface[] nodeInterfaceArray2 = this.getAnnotationList();
        if (nodeInterfaceArray2 != null) {
            for (NodeInterface nodeInterface : nodeInterfaceArray2) {
                sCCDataSet.addAnnotation(((Annotation)nodeInterface).type(), ((Annotation)nodeInterface).onset(n), ((Annotation)nodeInterface).offset(n), ((Annotation)nodeInterface).content());
            }
        }
        return sCCDataSet;
    }

    public SCC.HeaderElement getFirstTempo() {
        return SCCUtils.getFirstHeader(this, "TEMPO");
    }

    public SCC.HeaderElement getFirstKey() {
        return SCCUtils.getFirstHeader(this, "KEY");
    }

    class EasyChord {
        public int onset;
        public int offset;
        public String chord;

        public EasyChord(int n, int n2, String string) {
            this.onset = n;
            this.offset = n2;
            this.chord = string;
        }
    }

    private class NumberedNote
    extends MutableNote {
        private int partid;
        private byte number;

        private NumberedNote(int n, int n2, int n3, int n4, int n5, int n6) {
            this(n, n2, n3, n4, n4, n5, n6);
        }

        private NumberedNote(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            super(n, n2, n3, n4, n5, n6);
            this.number = 1;
            this.partid = n7;
        }

        private NumberedNote(NumberedNote numberedNote) {
            this(numberedNote.onset(), numberedNote.offset(), numberedNote.notenum(), numberedNote.velocity(), numberedNote.offVelocity(), numberedNote.ticksPerBeat(), numberedNote.partid);
            this.number = numberedNote.number;
        }

        public boolean equals(Object object) {
            if (object instanceof NumberedNote) {
                NumberedNote numberedNote = (NumberedNote)object;
                return super.equals(numberedNote) && this.number == numberedNote.number && this.partid == numberedNote.partid;
            }
            return false;
        }
    }

    public class PitchBend
    extends Note {
        private PitchBend(Node node, Part part) {
            super(node, part);
        }

        protected String getSupportedNodeName() {
            return "pitch-bend";
        }

        public final int value() {
            return this.notenum();
        }
    }

    public class ControlChange
    extends Note {
        private ControlChange(Node node, Part part) {
            super(node, part);
        }

        protected String getSuppotedNodeName() {
            return "control";
        }

        public final int ctrlnum() {
            return this.notenum();
        }

        public final int value() {
            return this.velocity();
        }
    }

    public class Note
    extends NodeInterface
    implements SCC.Note {
        private Part part;
        private int onset;
        private int offset;
        private int notenum;
        private int velocity;
        private int offVelocity;
        private int onsetInMSec;
        private int offsetInMSec;
        private String xpath;

        private Note(Node node, Part part) {
            super(node);
            this.part = part;
            String[] stringArray = Note.getText(this.node()).split("\\s");
            this.onset = Integer.parseInt(stringArray[0]);
            this.offset = Integer.parseInt(stringArray[1]);
            this.notenum = Integer.parseInt(stringArray[2]);
            if (stringArray.length >= 4) {
                this.velocity = Integer.parseInt(stringArray[3]);
            }
            this.offVelocity = stringArray.length >= 5 ? Integer.parseInt(stringArray[4]) : this.velocity;
        }

        protected String getSupportedNodeName() {
            return "note|control";
        }

        public final int onset() {
            return this.onset;
        }

        public final int onset(int n) {
            if (n == SCCXMLWrapper.this.getDivision()) {
                return this.onset;
            }
            return this.onset * n / SCCXMLWrapper.this.getDivision();
        }

        public final int offset() {
            return this.offset;
        }

        public final int offset(int n) {
            if (n == SCCXMLWrapper.this.getDivision()) {
                return this.offset;
            }
            return this.offset * n / SCCXMLWrapper.this.getDivision();
        }

        public final int duration(int n) {
            return this.offset(n) - this.onset(n);
        }

        public final int notenum() {
            return this.notenum;
        }

        public final int velocity() {
            return this.velocity;
        }

        public final int offVelocity() {
            return this.offVelocity;
        }

        public final Part part() {
            return this.part;
        }

        public final int onsetInMSec() {
            return this.onsetInMSec;
        }

        public final int onsetInMilliSec() {
            return this.onsetInMSec;
        }

        public final int offsetInMSec() {
            return this.offsetInMSec;
        }

        public final int offsetInMilliSec() {
            return this.offsetInMSec;
        }

        public MusicXMLWrapper.Note getMusicXMLWrapperNote() {
            NumberedNote numberedNote = new NumberedNote(this.onset, this.offset, this.notenum, this.velocity, this.offVelocity, SCCXMLWrapper.this.getDivision(), this.part.serial());
            if (this.hasAttribute("number")) {
                numberedNote.number = Byte.parseByte(this.getAttribute("number"));
            }
            return (MusicXMLWrapper.Note)SCCXMLWrapper.this.notemap.get(numberedNote);
        }

        public boolean isEqualNoteTo(Note note) {
            return this.onset == note.onset && this.offset == note.offset && this.notenum == note.notenum && this.velocity == note.velocity && this.offVelocity == note.offVelocity;
        }

        public String toString() {
            return "Note[" + this.onset + ", " + this.offset + ", " + this.notenum + ", " + this.velocity + ", " + this.offVelocity + "]";
        }

        public String getXPathExpression() {
            return this.xpath;
        }

        public String word() {
            if (this.hasAttribute("word")) {
                return this.getAttribute("word");
            }
            return null;
        }
    }

    public class Part
    extends NodeInterface
    implements SCC.Part {
        private Note[] notelist;
        private List<Note> noteonlylist;
        private String xpath;

        private Part(Node node) {
            super(node);
            this.notelist = null;
            this.noteonlylist = null;
        }

        protected final String getSupportedNodeName() {
            return "part";
        }

        public void eachnote(Closure closure) throws TransformerException {
            SCCUtils.eachnote(this, closure);
        }

        public Note[] getNoteList() {
            if (this.notelist == null) {
                NodeList nodeList = this.getChildNodes();
                int n = nodeList.getLength();
                this.notelist = new Note[n];
                this.noteonlylist = new ArrayList<Note>();
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeName().equals("note")) {
                        this.notelist[i] = new Note(node, this);
                        this.noteonlylist.add(this.notelist[i]);
                        this.notelist[i].xpath = this.getXPathExpression() + "/note[" + n2 + "]";
                        ++n2;
                        continue;
                    }
                    if (node.getNodeName().equals("control")) {
                        this.notelist[i] = new ControlChange(node, this);
                        this.notelist[i].xpath = this.getXPathExpression() + "/control[" + n3 + "]";
                        ++n3;
                        continue;
                    }
                    if (!node.getNodeName().equals("pitch-bend")) continue;
                    this.notelist[i] = new PitchBend(node, this);
                    this.notelist[i].xpath = this.getXPathExpression() + "/pitch-bend[" + n4 + "]";
                    ++n4;
                }
            }
            return this.notelist;
        }

        public Note[] getNoteOnlyList() {
            if (this.noteonlylist == null) {
                this.getNoteList();
            }
            return this.noteonlylist.toArray(new Note[this.noteonlylist.size()]);
        }

        public Note[] getSortedNoteList() {
            Note[] noteArray = (Note[])this.getNoteList().clone();
            Arrays.sort(noteArray, new Comparator<Note>(){

                @Override
                public int compare(Note note, Note note2) {
                    return note.onset() == note2.onset() ? (note.offset() == note2.offset() ? (note.notenum() == note2.notenum() ? note.velocity() - note2.velocity() : note.notenum() - note2.notenum()) : note.offset() - note2.offset()) : note.onset() - note2.onset();
                }
            });
            return noteArray;
        }

        public Note[] getSortedNoteOnlyList() {
            Note[] noteArray = (Note[])this.getNoteOnlyList().clone();
            Arrays.sort(noteArray, new Comparator<Note>(){

                @Override
                public int compare(Note note, Note note2) {
                    return note.onset() == note2.onset() ? (note.offset() == note2.offset() ? (note.notenum() == note2.notenum() ? note.velocity() - note2.velocity() : note.notenum() - note2.notenum()) : note.offset() - note2.offset()) : note.onset() - note2.onset();
                }
            });
            return noteArray;
        }

        public Note[] getSortedNoteList(final int n) {
            Note[] noteArray = (Note[])this.getNoteList().clone();
            Arrays.sort(noteArray, new Comparator<Note>(){

                @Override
                public int compare(Note note, Note note2) {
                    return Math.abs(note.onset() - note2.onset()) < n ? (note.notenum() == note2.notenum() ? note.velocity() - note2.velocity() : note.notenum() - note2.notenum()) : note.onset() - note2.onset();
                }
            });
            return noteArray;
        }

        public Note[] getSortedNoteOnlyList(final int n) {
            Note[] noteArray = (Note[])this.getNoteOnlyList().clone();
            Arrays.sort(noteArray, new Comparator<Note>(){

                @Override
                public int compare(Note note, Note note2) {
                    return Math.abs(note.onset() - note2.onset()) < n ? (note.notenum() == note2.notenum() ? note.velocity() - note2.velocity() : note.notenum() - note2.notenum()) : note.onset() - note2.onset();
                }
            });
            return noteArray;
        }

        public MIDIEventList toMIDIEventList() {
            byte by = this.channel();
            MIDIEventList mIDIEventList = new MIDIEventList();
            Note[] noteArray = this.getNoteList();
            mIDIEventList.addEvent(0, (short)192, by, this.prognum(), 0);
            mIDIEventList.addEvent(0, (short)176, by, 7, this.volume());
            for (Note note : noteArray) {
                if (note instanceof ControlChange) {
                    mIDIEventList.addEvent(note.onset(), (short)176, by, ((ControlChange)note).ctrlnum(), ((ControlChange)note).value());
                    continue;
                }
                if (note instanceof PitchBend) {
                    mIDIEventList.addEvent(note.onset(), (short)224, by, ((PitchBend)note).value(), 0);
                    continue;
                }
                mIDIEventList.addEvent(note.onset(), (short)144, by, note.notenum(), note.velocity());
                mIDIEventList.addEvent(note.offset(), (short)128, by, note.notenum(), note.velocity());
            }
            return mIDIEventList;
        }

        public final int serial() {
            return Part.getAttributeInt(this.node(), "serial");
        }

        public final byte channel() {
            return Byte.parseByte(Part.getAttribute(this.node(), "ch"));
        }

        public final int prognum() {
            return Part.getAttributeInt(this.node(), "pn");
        }

        public final int volume() {
            return Part.getAttributeInt(this.node(), "vol");
        }

        public final int panpot() {
            return Part.getAttributeInt(this.node(), "pan");
        }

        public final String name() {
            return Part.getAttribute(this.node(), "name");
        }

        public final String getXPathExpression() {
            return this.xpath;
        }
    }

    public class HeaderElement
    extends NodeInterface
    implements SCC.HeaderElement {
        private int timestamp;
        private String name;
        private String content;

        private HeaderElement(Node node) {
            super(node);
            this.timestamp = HeaderElement.getAttributeInt(node, "time");
            this.name = HeaderElement.getAttribute(node, "name");
            this.content = HeaderElement.getAttribute(node, "content");
        }

        protected String getSupportedNodeName() {
            return "meta";
        }

        public int time() {
            return this.timestamp;
        }

        public String name() {
            return this.name;
        }

        public String content() {
            return this.content;
        }

        public boolean equals(SCC.HeaderElement headerElement) {
            return this.timestamp == headerElement.time() && this.name.equals(headerElement.name()) && this.content.equals(headerElement.content());
        }

        public int compareTo(SCC.HeaderElement headerElement) {
            if (this.timestamp != headerElement.time()) {
                return this.timestamp - headerElement.time();
            }
            if (!this.name.equals(headerElement.name())) {
                return this.name.compareTo(headerElement.name());
            }
            if (!this.content.equals(headerElement.content())) {
                return this.content.compareTo(headerElement.content());
            }
            return 0;
        }
    }

    public class Annotation
    extends NodeInterface
    implements SCC.Annotation {
        private int onset;
        private int offset;
        private String content;

        private Annotation(Node node) {
            super(node);
            String[] stringArray = Annotation.getText(this.node()).split("\\s");
            this.onset = Integer.parseInt(stringArray[0]);
            this.offset = stringArray.length >= 2 ? Integer.parseInt(stringArray[1]) : this.onset;
            this.content = stringArray.length >= 3 ? stringArray[2] : null;
        }

        protected String getSupportedNodeName() {
            return "chord|barline|lyrics";
        }

        public final int onset() {
            return this.onset;
        }

        public final int offset() {
            return this.offset;
        }

        public final String content() {
            return this.content;
        }

        public final int onset(int n) {
            if (n == SCCXMLWrapper.this.getDivision()) {
                return this.onset;
            }
            return this.onset * n / SCCXMLWrapper.this.getDivision();
        }

        public final int offset(int n) {
            if (n == SCCXMLWrapper.this.getDivision()) {
                return this.offset;
            }
            return this.offset * n / SCCXMLWrapper.this.getDivision();
        }

        public final String type() {
            return this.getNodeName();
        }
    }
}

