/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.ComplexNumber;
import jp.crestmuse.cmx.math.MathUtils;
import jp.crestmuse.cmx.math.Utils;
import jp.crestmuse.cmx.misc.Encodable;

public abstract class AbstractComplexArrayImpl
implements ComplexArray,
Encodable {
    public void set(int n, double d, double d2) {
        this.setReal(n, d);
        this.setImag(n, d2);
    }

    public void set(int n, ComplexNumber complexNumber) {
        this.set(n, complexNumber.real, complexNumber.imag);
    }

    public ComplexNumber get(int n) {
        return new ComplexNumber(this.getReal(n), this.getImag(n));
    }

    public ComplexArray clone() throws CloneNotSupportedException {
        ComplexArray complexArray = Utils.createComplexArray(this.length());
        for (int i = 0; i < this.length(); ++i) {
            complexArray.set(i, this.getReal(i), this.getImag(i));
        }
        return complexArray;
    }

    public String toString() {
        return MathUtils.toString1(this);
    }

    public String encode() {
        return MathUtils.toString2(this);
    }

    public ComplexArray subarrayX(int n, int n2) {
        try {
            ComplexArray complexArray = this.clone();
            return complexArray.subarrayX(n, n2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException();
        }
    }
}

