/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import jp.crestmuse.cmx.math.ComplexMatrix;
import jp.crestmuse.cmx.math.ComplexNumber;
import jp.crestmuse.cmx.math.MathUtils;

public abstract class AbstractComplexMatrixImpl
implements ComplexMatrix,
Cloneable {
    public ComplexNumber get(int n, int n2) {
        return new ComplexNumber(this.getReal(n, n2), this.getImag(n, n2));
    }

    public void set(int n, int n2, double d, double d2) {
        this.setReal(n, n2, d);
        this.setImag(n, n2, d2);
    }

    public void set(int n, int n2, ComplexNumber complexNumber) {
        this.set(n, n2, complexNumber.real, complexNumber.imag);
    }

    public ComplexMatrix clone() throws CloneNotSupportedException {
        ComplexMatrix complexMatrix = MathUtils.createComplexMatrix(this.nrows(), this.ncols());
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                complexMatrix.set(i, j, this.getReal(i, j), this.getImag(i, j));
            }
        }
        return complexMatrix;
    }

    public String toString() {
        return MathUtils.toString1(this);
    }

    public String encode() {
        return MathUtils.toString2(this);
    }
}

