/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

public final class NoteSymbol {
    private final NoteName notename;
    private final Sign sign;

    public NoteSymbol(NoteName noteName, Sign sign) {
        this.notename = noteName;
        this.sign = sign;
    }

    public NoteSymbol(int n, boolean bl) {
        if (bl) {
            this.notename = NoteName.LIST_SHARP[n];
            this.sign = Sign.LIST_SHARP[n];
        } else {
            this.notename = NoteName.LIST_FLAT[n];
            this.sign = Sign.LIST_FLAT[n];
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NoteSymbol) {
            NoteSymbol noteSymbol = (NoteSymbol)object;
            return this.notename.equals((Object)noteSymbol.notename) && this.sign.equals((Object)noteSymbol.sign);
        }
        return false;
    }

    public int hashCode() {
        return this.notename.hashCode() + this.sign.hashCode();
    }

    public String toString() {
        return this.encode();
    }

    public String encode() {
        return this.notename.toString() + this.sign.toString();
    }

    public int number() {
        return this.notename.value + this.sign.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sign {
        NONE(0, ""),
        SHARP(1, "#"),
        FLAT(-1, "b");

        private static final Sign[] LIST_SHARP;
        private static final Sign[] LIST_FLAT;
        private final int value;
        private final String s;

        private Sign(int n2, String string2) {
            this.value = n2;
            this.s = string2;
        }

        public String toString() {
            return this.s;
        }

        static {
            LIST_SHARP = new Sign[]{NONE, SHARP, NONE, SHARP, NONE, NONE, SHARP, NONE, SHARP, NONE, SHARP, NONE};
            LIST_FLAT = new Sign[]{NONE, FLAT, NONE, FLAT, NONE, NONE, FLAT, NONE, FLAT, NONE, FLAT, NONE};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoteName {
        C(0),
        D(2),
        E(4),
        F(5),
        G(7),
        A(9),
        B(11);

        private static final NoteName[] LIST_SHARP;
        private static final NoteName[] LIST_FLAT;
        private int value;

        private NoteName(int n2) {
            this.value = n2;
        }

        static {
            LIST_SHARP = new NoteName[]{C, C, D, D, E, F, F, G, G, A, A, B};
            LIST_FLAT = new NoteName[]{C, D, D, E, E, F, G, G, A, A, B, B};
        }
    }
}

