/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.handlers.NoteHandlerPartwise;
import jp.crestmuse.cmx.misc.Misc;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviationInstanceGeneratorSample
extends CMXCommand<MusicXMLWrapper, DeviationInstanceWrapper> {
    private DeviationDataSet dds;

    @Override
    protected DeviationInstanceWrapper run(MusicXMLWrapper musicXMLWrapper) throws IOException, ParserConfigurationException, TransformerException, SAXException, InvalidFileTypeException {
        this.dds = new DeviationDataSet(musicXMLWrapper);
        musicXMLWrapper.processNotePartwise(new SampleHandler());
        return this.dds.toWrapper();
    }

    public static void main(String[] stringArray) {
        DeviationInstanceGeneratorSample deviationInstanceGeneratorSample = new DeviationInstanceGeneratorSample();
        try {
            deviationInstanceGeneratorSample.start(stringArray);
        }
        catch (Exception exception) {
            deviationInstanceGeneratorSample.showErrorMessage(exception);
            System.exit(1);
        }
    }

    private class SampleHandler
    implements NoteHandlerPartwise {
        private SampleHandler() {
        }

        public void beginPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
            System.out.println("Part " + part.id());
        }

        public void endPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
        }

        public void beginMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
            System.out.println("Measure " + measure.number());
        }

        public void endMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
        }

        public void processMusicData(MusicXMLWrapper.MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
            if (musicData instanceof MusicXMLWrapper.Note) {
                double d;
                MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                String string = "Note[" + note.pitchStep();
                if (note.pitchAlter() > 0) {
                    string = string + "#";
                } else if (note.pitchAlter() < 0) {
                    string = string + "b";
                }
                string = string + note.pitchOctave() + ", " + note.duration() + "]";
                System.out.println(string);
                if (Misc.inputYesNo("require deviation? ")) {
                    d = Misc.inputDouble("attack? ");
                    double d2 = Misc.inputDouble("release? ");
                    double d3 = Misc.inputDouble("dynamics? ");
                    double d4 = Misc.inputDouble("end-dynamics? ");
                    DeviationInstanceGeneratorSample.this.dds.addNoteDeviation(note, d, d2, d3, d4);
                }
                while (Misc.inputYesNo("input non-partwise control here? ")) {
                    System.out.println("measure is " + note.measure().number());
                    d = Misc.inputDouble("beat? ");
                    String string2 = Misc.inputString("type? ");
                    double d5 = Misc.inputDouble("value? ");
                    DeviationInstanceGeneratorSample.this.dds.addNonPartwiseControl(note.measure().number(), d, string2, d5);
                }
            }
        }
    }
}

