/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.elements;

import jp.crestmuse.cmx.elements.NoteCompatible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MutableMusicEvent
implements Comparable<MutableMusicEvent>,
NoteCompatible {
    int onset;
    int offset;
    int value1;
    int value2;
    int value3;
    int ticksPerBeat;
    Type type;

    MutableMusicEvent(Type type, int n, int n2, int n3) {
        this.type = type;
        this.onset = n;
        this.offset = n2;
        this.value3 = 0;
        this.value2 = 0;
        this.value1 = 0;
        this.ticksPerBeat = n3;
    }

    public void setOnset(int n) {
        this.onset = n;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int onset() {
        return this.onset;
    }

    @Override
    public int onset(int n) {
        if (n == this.ticksPerBeat) {
            return this.onset;
        }
        return this.onset * n / this.ticksPerBeat;
    }

    public int onsetInMSec() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int onsetInMilliSec() {
        throw new UnsupportedOperationException();
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public int offsetInMilliSec() {
        throw new UnsupportedOperationException();
    }

    public int offsetInMSec() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int offset(int n) {
        if (n == this.ticksPerBeat) {
            return this.offset;
        }
        return this.offset * n / this.ticksPerBeat;
    }

    @Override
    public int duration(int n) {
        return this.offset(n) - this.onset(n);
    }

    protected int ticksPerBeat() {
        return this.ticksPerBeat;
    }

    public boolean equals(Object object) {
        MutableMusicEvent mutableMusicEvent = (MutableMusicEvent)object;
        return this.type.equals((Object)mutableMusicEvent.type) && this.onset == mutableMusicEvent.onset && this.offset == mutableMusicEvent.offset && this.value1 == mutableMusicEvent.value1 && this.value2 == mutableMusicEvent.value2 && this.value3 == mutableMusicEvent.value3;
    }

    public int hashCode() {
        return this.onset + this.offset + this.value1 + this.value2 + this.value3;
    }

    @Override
    public int compareTo(MutableMusicEvent mutableMusicEvent) {
        return this.onset == mutableMusicEvent.onset ? (this.offset == mutableMusicEvent.offset ? (this.type.equals((Object)mutableMusicEvent.type) ? (this.value1 == mutableMusicEvent.value1 ? (this.value2 == mutableMusicEvent.value2 ? this.value3 - mutableMusicEvent.value3 : this.value2 - mutableMusicEvent.value2) : this.value1 - mutableMusicEvent.value1) : this.type.ordinal() - mutableMusicEvent.type.ordinal()) : this.offset - mutableMusicEvent.offset) : this.onset - mutableMusicEvent.onset;
    }

    @Override
    public int velocity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int offVelocity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int notenum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String word() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        NOTE,
        CONTROL_CHANGE,
        PITCH_BEND,
        ANNOTATION;

    }
}

