/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import groovy.lang.Closure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.elements.MutableAnnotation;
import jp.crestmuse.cmx.elements.MutableControlChange;
import jp.crestmuse.cmx.elements.MutableMusicEvent;
import jp.crestmuse.cmx.elements.MutableNote;
import jp.crestmuse.cmx.elements.MutablePitchBend;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.SCC;
import jp.crestmuse.cmx.filewrappers.SCCUtils;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;

public class SCCDataSet
implements SCC {
    private int division;
    private List<HeaderElement> headers = new ArrayList<HeaderElement>();
    private List<Part> parts = new ArrayList<Part>();
    private List<MutableAnnotation> annotations = new ArrayList<MutableAnnotation>();

    public SCCDataSet(int n) {
        this.division = n;
    }

    public void addAnnotation(String string, int n, int n2, String string2) {
        this.annotations.add(new MutableAnnotation(n, n2, string, string2, this.division));
    }

    public void addBarline(int n, String string) {
        this.addAnnotation("barline", n, n, string);
    }

    public void addChord(int n, int n2, String string) {
        this.addAnnotation("chord", n, n2, string);
    }

    public void addHeaderElement(int n, String string, String string2) {
        this.headers.add(new HeaderElement(n, string, string2));
    }

    public Part addPart(int n, int n2, int n3, int n4) {
        return this.addPart(n, n2, n3, n4, (String)null);
    }

    public Part addPart(int n, int n2, int n3, int n4, String string) {
        Part part = new Part(n, (byte)n2, n3, n4, string);
        this.parts.add(part);
        return part;
    }

    public void addPart(int n, int n2, int n3, int n4, Closure closure) {
        this.addPart(n, n2, n3, n4, null, closure);
    }

    public void addPart(int n, int n2, int n3, int n4, String string, Closure closure) {
        Part part = this.addPart(n, n2, n3, n4, string);
        closure.call(new Object[]{part});
    }

    public Part[] getPartList() {
        return this.parts.toArray(new Part[this.parts.size()]);
    }

    public Part getPart(int n) {
        return this.parts.get(n);
    }

    public Part getPartWithSerial(int n) {
        for (Part part : this.parts) {
            if (part.serial() != n) continue;
            return part;
        }
        return null;
    }

    public Part[] getPartsWithChannel(int n) {
        ArrayList<Part> arrayList = new ArrayList<Part>();
        for (Part part : this.parts) {
            if (part.channel() != n) continue;
            arrayList.add(part);
        }
        return arrayList.toArray(new Part[arrayList.size()]);
    }

    public Part getFirstPartWithChannel(int n) {
        for (Part part : this.parts) {
            if (part.channel() != n) continue;
            return part;
        }
        return null;
    }

    public HeaderElement[] getHeaderElementList() {
        return this.headers.toArray(new HeaderElement[this.headers.size()]);
    }

    public MutableAnnotation[] getAnnotationList() {
        return this.annotations.toArray(new MutableAnnotation[this.annotations.size()]);
    }

    public SCC.Annotation[] getChordList() {
        return SCCUtils.getChordList(this);
    }

    public SCC.Annotation[] getBarlineList() {
        return SCCUtils.getBarlineList(this);
    }

    public boolean removeAnnotation(MutableAnnotation mutableAnnotation) {
        return this.annotations.remove(mutableAnnotation);
    }

    public boolean removeHeaderElement(HeaderElement headerElement) {
        return this.headers.remove(headerElement);
    }

    public boolean removePart(Part part) {
        return this.parts.remove(part);
    }

    public int getDivision() {
        return this.division;
    }

    public void eachpart(Closure closure) throws TransformerException {
        SCCUtils.eachpart(this, closure);
    }

    public void eachnote(Closure closure) throws TransformerException {
        SCCUtils.eachnote(this, closure);
    }

    public void eachchord(Closure closure) throws TransformerException {
        SCCUtils.eachchord(this, closure);
    }

    public void eachbarline(Closure closure) throws TransformerException {
        SCCUtils.eachbarline(this, closure);
    }

    public SCCDataSet toDataSet() throws TransformerException {
        return this;
    }

    public SCCXMLWrapper toWrapper() throws TransformerException {
        try {
            int n;
            SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument("scc");
            int n2 = this.getDivision();
            sCCXMLWrapper.setDivision(n2);
            HeaderElement[] headerElementArray = this.getHeaderElementList();
            sCCXMLWrapper.beginHeader();
            Object[] objectArray = headerElementArray;
            int n3 = objectArray.length;
            for (n = 0; n < n3; ++n) {
                HeaderElement headerElement = objectArray[n];
                sCCXMLWrapper.addHeaderElement(headerElement.time(), headerElement.name(), headerElement.content());
            }
            sCCXMLWrapper.endHeader();
            Object[] objectArray2 = objectArray = this.getPartList();
            n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2 = objectArray2[i];
                sCCXMLWrapper.newPart(((Part)object2).serial(), ((Part)object2).channel(), ((Part)object2).prognum(), ((Part)object2).volume(), ((Part)object2).name());
                for (Object object3 : object = ((Part)object2).getNoteList()) {
                    MutableMusicEvent mutableMusicEvent;
                    if (object3 instanceof MutableControlChange) {
                        mutableMusicEvent = (MutableControlChange)object3;
                        sCCXMLWrapper.addControlChange(mutableMusicEvent.onset(n2), ((MutableControlChange)mutableMusicEvent).ctrlnum(), ((MutableControlChange)mutableMusicEvent).value());
                        continue;
                    }
                    if (object3 instanceof MutablePitchBend) {
                        mutableMusicEvent = (MutablePitchBend)object3;
                        sCCXMLWrapper.addPitchBend(mutableMusicEvent.onset(n2), ((MutablePitchBend)mutableMusicEvent).value());
                        continue;
                    }
                    if (object3.word() == null) {
                        sCCXMLWrapper.addNoteElement(object3.onset(n2), object3.offset(n2), object3.notenum(), object3.velocity(), object3.offVelocity());
                        continue;
                    }
                    sCCXMLWrapper.addNoteElementWithWord(object3.word(), object3.onset(n2), object3.offset(n2), object3.notenum(), object3.velocity(), object3.offVelocity());
                }
                sCCXMLWrapper.endPart();
            }
            sCCXMLWrapper.beginAnnotations();
            for (Object object : objectArray2 = this.getAnnotationList()) {
                sCCXMLWrapper.addAnnotation(object.type(), object.onset(n2), object.offset(n2), object.content());
            }
            sCCXMLWrapper.endAnnotations();
            sCCXMLWrapper.finalizeDocument();
            return sCCXMLWrapper;
        }
        catch (InvalidFileTypeException invalidFileTypeException) {
            throw new IllegalStateException();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new TransformerException(iOException.toString());
        }
    }

    public class Part
    implements SCC.Part {
        private List<MutableMusicEvent> notes = new ArrayList<MutableMusicEvent>();
        private byte channel;
        private int panpot;
        private int prognum;
        private int serial;
        private int volume;
        String name;

        private Part(int n, byte by, int n2, int n3, String string) {
            this.serial = n;
            this.channel = by;
            this.prognum = n2;
            this.volume = n3;
            this.name = string;
        }

        public boolean remove(MutableMusicEvent mutableMusicEvent) {
            return this.notes.remove(mutableMusicEvent);
        }

        public void addNoteElement(int n, int n2, int n3, int n4, int n5) {
            this.notes.add(new MutableNote(n, n2, n3, n4, n5, SCCDataSet.this.division));
        }

        public void addNoteElementWithWord(String string, int n, int n2, int n3, int n4, int n5) {
            this.notes.add(new MutableNote(n, n2, n3, n4, n5, string, SCCDataSet.this.division));
        }

        public void addControlChange(int n, int n2, int n3) {
            this.notes.add(new MutableControlChange(n, n2, n3, SCCDataSet.this.division));
        }

        public void addPitchBend(int n, int n2) {
            this.notes.add(new MutablePitchBend(n, n2, SCCDataSet.this.division));
        }

        public void eachnote(Closure closure) throws TransformerException {
            SCCUtils.eachnote(this, closure);
        }

        public MutableMusicEvent[] getNoteList() {
            return this.notes.toArray(new MutableMusicEvent[this.notes.size()]);
        }

        public MutableNote[] getNoteOnlyList() {
            ArrayList<MutableNote> arrayList = new ArrayList<MutableNote>();
            for (MutableMusicEvent mutableMusicEvent : this.notes) {
                if (!(mutableMusicEvent instanceof MutableNote)) continue;
                arrayList.add((MutableNote)mutableMusicEvent);
            }
            return arrayList.toArray(new MutableNote[arrayList.size()]);
        }

        public MutableMusicEvent[] getSortedNoteList() {
            Object[] objectArray = (MutableMusicEvent[])this.getNoteList().clone();
            Arrays.sort(objectArray);
            return objectArray;
        }

        public MutableNote[] getSortedNoteOnlyList() {
            Object[] objectArray = (MutableNote[])this.getNoteOnlyList().clone();
            Arrays.sort(objectArray);
            return objectArray;
        }

        public int serial() {
            return this.serial;
        }

        public byte channel() {
            return this.channel;
        }

        public int prognum() {
            return this.prognum;
        }

        public int volume() {
            return this.volume;
        }

        public int panpot() {
            return this.panpot;
        }

        public String name() {
            return this.name;
        }
    }

    public class HeaderElement
    implements SCC.HeaderElement {
        private String content;
        private String name;
        private int time;

        private HeaderElement(int n, String string, String string2) {
            this.time = n;
            this.name = string;
            this.content = string2;
        }

        public String content() {
            return this.content;
        }

        public String name() {
            return this.name;
        }

        public int time() {
            return this.time;
        }
    }
}

