/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import groovy.lang.Closure;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.SCC;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;

class SCCUtils {
    SCCUtils() {
    }

    static SCC.Annotation[] getChordList(SCC sCC) {
        SCC.Annotation[] annotationArray = sCC.getAnnotationList();
        if (annotationArray == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (!annotationArray[i].type().equals("chord")) continue;
            ++n;
        }
        SCC.Annotation[] annotationArray2 = new SCC.Annotation[n];
        int n2 = 0;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (!annotationArray[i].type().equals("chord")) continue;
            annotationArray2[n2] = annotationArray[i];
            ++n2;
        }
        return annotationArray2;
    }

    static SCC.Annotation[] getBarlineList(SCC sCC) {
        SCC.Annotation[] annotationArray = sCC.getAnnotationList();
        if (annotationArray == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (!annotationArray[i].type().equals("barline")) continue;
            ++n;
        }
        SCC.Annotation[] annotationArray2 = new SCC.Annotation[n];
        int n2 = 0;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (!annotationArray[i].type().equals("barline")) continue;
            annotationArray2[n2] = annotationArray[i];
            ++n2;
        }
        return annotationArray2;
    }

    static SCCXMLWrapper toWrapper(SCC sCC) throws TransformerException {
        try {
            int n;
            SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument("scc");
            int n2 = sCC.getDivision();
            sCCXMLWrapper.setDivision(n2);
            SCC.HeaderElement[] headerElementArray = sCC.getHeaderElementList();
            sCCXMLWrapper.beginHeader();
            Object[] objectArray = headerElementArray;
            int n3 = objectArray.length;
            for (n = 0; n < n3; ++n) {
                SCC.HeaderElement headerElement = objectArray[n];
                sCCXMLWrapper.addHeaderElement(headerElement.time(), headerElement.name(), headerElement.content());
            }
            sCCXMLWrapper.endHeader();
            Object[] objectArray2 = objectArray = sCC.getPartList();
            n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2 = objectArray2[i];
                sCCXMLWrapper.newPart(object2.serial(), object2.channel(), object2.prognum(), object2.volume(), object2.name());
                for (Object object3 : object = object2.getNoteList()) {
                    if (object3.word() == null) {
                        sCCXMLWrapper.addNoteElement(object3.onset(n2), object3.offset(n2), object3.notenum(), object3.velocity(), object3.offVelocity());
                        continue;
                    }
                    sCCXMLWrapper.addNoteElementWithWord(object3.word(), object3.onset(n2), object3.offset(n2), object3.notenum(), object3.velocity(), object3.offVelocity());
                }
                sCCXMLWrapper.endPart();
            }
            sCCXMLWrapper.beginAnnotations();
            for (Object object : objectArray2 = sCC.getAnnotationList()) {
                sCCXMLWrapper.addAnnotation(object.type(), object.onset(n2), object.offset(n2), object.content());
            }
            sCCXMLWrapper.endAnnotations();
            sCCXMLWrapper.finalizeDocument();
            return sCCXMLWrapper;
        }
        catch (InvalidFileTypeException invalidFileTypeException) {
            throw new IllegalStateException();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new TransformerException(iOException.toString());
        }
    }

    static void eachnote(SCC sCC, Closure closure) throws TransformerException {
        SCC.Part[] partArray;
        for (SCC.Part part : partArray = sCC.getPartList()) {
            SCC.Note[] noteArray;
            for (SCC.Note note : noteArray = part.getNoteList()) {
                closure.call(new Object[]{note});
            }
        }
    }

    static void eachpart(SCC sCC, Closure closure) throws TransformerException {
        SCC.Part[] partArray;
        for (SCC.Part part : partArray = sCC.getPartList()) {
            closure.call(new Object[]{part});
        }
    }

    static void eachnote(SCC.Part part, Closure closure) throws TransformerException {
        SCC.Note[] noteArray;
        for (SCC.Note note : noteArray = part.getNoteList()) {
            closure.call(new Object[]{note});
        }
    }

    static void eachchord(SCC sCC, Closure closure) throws TransformerException {
        SCC.Annotation[] annotationArray;
        for (SCC.Annotation annotation : annotationArray = sCC.getChordList()) {
            closure.call(new Object[]{annotation});
        }
    }

    static void eachbarline(SCC sCC, Closure closure) throws TransformerException {
        SCC.Annotation[] annotationArray;
        for (SCC.Annotation annotation : annotationArray = sCC.getBarlineList()) {
            closure.call(new Object[]{annotation});
        }
    }
}

