/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.LinkedList;
import jp.crestmuse.cmx.inference.BayesNetCompatible;
import jp.crestmuse.cmx.inference.BayesNetException;
import jp.crestmuse.cmx.inference.BayesianMapping;
import jp.crestmuse.cmx.inference.MusicCalculator;
import jp.crestmuse.cmx.inference.MusicElement;
import jp.crestmuse.cmx.inference.MusicRepresentation;

public class BayesianCalculator
implements MusicCalculator {
    private BayesNetCompatible bayesNet;
    private LinkedList<BayesianMapping> readMappings;
    private LinkedList<BayesianMapping> writeMappings;

    public BayesianCalculator(BayesNetCompatible bayesNetCompatible) {
        this.bayesNet = bayesNetCompatible;
        this.readMappings = new LinkedList();
        this.writeMappings = new LinkedList();
    }

    public void updated(int n, int n2, String string, MusicRepresentation musicRepresentation) {
        MusicElement musicElement;
        for (BayesianMapping bayesianMapping : this.readMappings) {
            int n3;
            musicElement = bayesianMapping.mappedElement(musicRepresentation, n, n2);
            if (musicElement == null || !(musicElement.getProb(n3 = musicElement.getHighestProbIndex()) > 0.5)) continue;
            this.bayesNet.setEvidence(bayesianMapping.bayesnetIndex, n3);
        }
        try {
            this.bayesNet.update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BayesNetException(exception.toString());
        }
        for (BayesianMapping bayesianMapping : this.writeMappings) {
            musicElement = bayesianMapping.mappedElement(musicRepresentation, n, n2);
            if (musicElement == null) continue;
            double[] dArray = this.bayesNet.getMargin(bayesianMapping.bayesnetIndex);
            for (int i = 0; i < dArray.length; ++i) {
                musicElement.setProb(i, dArray[i]);
            }
        }
    }

    public void addReadMapping(BayesianMapping bayesianMapping) {
        this.readMappings.add(bayesianMapping);
    }

    public void addWriteMapping(BayesianMapping bayesianMapping) {
        this.writeMappings.add(bayesianMapping);
    }
}

