/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ChordSymbol {
    private Root root;
    private Sign sign;
    private Mode mode;
    private Seventh seventh;
    private static Pattern p = Pattern.compile("([CDEFGAB])(|\\#|b)(|M|maj|major|m|min|minor|aug|augument|augumented|dim|diminish|diminished)(|7|M7|maj7|major7)");

    public ChordSymbol(Root root, Sign sign, Mode mode, Seventh seventh) {
        this.root = root;
        this.sign = sign;
        this.mode = mode;
        this.seventh = seventh;
    }

    public static ChordSymbol[] getChordSymbolList(String[] stringArray) {
        ChordSymbol[] chordSymbolArray = new ChordSymbol[stringArray.length];
        for (int i = 0; i < chordSymbolArray.length; ++i) {
            chordSymbolArray[i] = ChordSymbol.parse(stringArray[i]);
        }
        return chordSymbolArray;
    }

    public static ChordSymbol parse(String string) {
        return ChordSymbol.parse(string, false);
    }

    public static ChordSymbol parse(String string, boolean bl) {
        Matcher matcher = p.matcher(string = string.trim());
        if (matcher.matches()) {
            return new ChordSymbol(ChordSymbol.parseRoot(matcher.group(1)), ChordSymbol.parseSign(matcher.group(2)), ChordSymbol.parseMode(matcher.group(3)), bl ? Seventh.NONE : ChordSymbol.parseSeventh(matcher.group(4), matcher.group(3)));
        }
        throw new IllegalStateException("Invalid chord symbol: " + string);
    }

    public static void addStringMap(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        Sign.strings.put(string, stringArray);
        Mode.strings.put(string, stringArray2);
        Seventh.strings.put(string, stringArray3);
    }

    public String encode() {
        return this.encode("default", false);
    }

    public String encode(String string, boolean bl) {
        return this.root.toString() + this.sign.toString(string) + this.mode.toString(string) + (bl ? "" : this.seventh.toString(string));
    }

    public static String[] encodeAll(ChordSymbol[] chordSymbolArray) {
        String[] stringArray = new String[chordSymbolArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = chordSymbolArray[i].encode();
        }
        return stringArray;
    }

    public static String[] encodeAll(ChordSymbol[] chordSymbolArray, String string, boolean bl) {
        String[] stringArray = new String[chordSymbolArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = chordSymbolArray[i].encode(string, bl);
        }
        return stringArray;
    }

    private static Root parseRoot(String string) {
        if (string.equals("C")) {
            return Root.C;
        }
        if (string.equals("D")) {
            return Root.D;
        }
        if (string.equals("E")) {
            return Root.E;
        }
        if (string.equals("F")) {
            return Root.F;
        }
        if (string.equals("G")) {
            return Root.G;
        }
        if (string.equals("A")) {
            return Root.A;
        }
        if (string.equals("B")) {
            return Root.B;
        }
        throw new IllegalStateException("Invalid root note: " + string);
    }

    private static Sign parseSign(String string) {
        if (string.equals("")) {
            return Sign.NONE;
        }
        if (string.equals("#")) {
            return Sign.SHARP;
        }
        if (string.equals("b")) {
            return Sign.FLAT;
        }
        throw new IllegalStateException("Invalid sign: " + string);
    }

    private static Mode parseMode(String string) {
        if (string.equals("") || string.equals("M") || string.startsWith("maj")) {
            return Mode.MAJ;
        }
        if (string.equals("m") || string.startsWith("min")) {
            return Mode.MIN;
        }
        if (string.startsWith("aug")) {
            return Mode.AUG;
        }
        if (string.startsWith("dim")) {
            return Mode.DIM;
        }
        throw new IllegalStateException("Invalid mode: " + string);
    }

    private static Seventh parseSeventh(String string, String string2) {
        if (string.equals("")) {
            return Seventh.NONE;
        }
        if (string.equals("7") && (string2.equals("M") || string2.startsWith("maj"))) {
            return Seventh.MAJ7;
        }
        if (string.equals("7")) {
            return Seventh.DOM7;
        }
        if (string.startsWith("M7") || string.startsWith("maj")) {
            return Seventh.MAJ7;
        }
        throw new IllegalStateException("Invalid seventh: " + string);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ChordSymbol) {
            ChordSymbol chordSymbol = (ChordSymbol)object;
            return this.root.equals((Object)chordSymbol.root) && this.sign.equals((Object)chordSymbol.sign) && this.mode.equals((Object)chordSymbol.mode) && this.seventh.equals((Object)chordSymbol.seventh);
        }
        return false;
    }

    public int hashCode() {
        return this.root.hashCode() + this.sign.hashCode() + this.mode.hashCode() + this.seventh.hashCode();
    }

    public String toString() {
        return this.encode();
    }

    static {
        ChordSymbol.addStringMap("default", new String[]{"", "#", "b"}, new String[]{"", "m", "aug", "dim"}, new String[]{"", "7", "maj7"});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Seventh {
        NONE,
        DOM7,
        MAJ7;

        static Map<String, String[]> strings;

        public String toString(String string) {
            return strings.get(string)[this.ordinal()];
        }

        static {
            strings = new HashMap<String, String[]>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        MAJ,
        MIN,
        AUG,
        DIM;

        static Map<String, String[]> strings;

        public String toString(String string) {
            return strings.get(string)[this.ordinal()];
        }

        static {
            strings = new HashMap<String, String[]>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sign {
        NONE,
        SHARP,
        FLAT;

        static Map<String, String[]> strings;

        public String toString(String string) {
            return strings.get(string)[this.ordinal()];
        }

        static {
            strings = new HashMap<String, String[]>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Root {
        C,
        D,
        E,
        F,
        G,
        A,
        B;

    }
}

