/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCC;

public class TimeFreqRepresentation {
    private List<TimeFreqElement> tflist;
    private int nbands;
    private static final int N_BANDS = 128;

    private TimeFreqRepresentation(int n) {
        this.nbands = n;
        this.tflist = new ArrayList<TimeFreqElement>();
    }

    private void add(double d, byte[] byArray, SCC.Note[] noteArray) {
        if (noteArray.length != this.nbands) {
            throw new IllegalStateException();
        }
        this.tflist.add(new TimeFreqElement(d, byArray, noteArray));
    }

    private void addTime(double d) {
        this.add(d, new byte[this.nbands], new SCC.Note[this.nbands]);
    }

    public TimeFreqElement get(int n) {
        return this.tflist.get(n);
    }

    private void set(int n, int n2, byte by) {
        ((TimeFreqElement)this.tflist.get((int)n)).values[n2] = by;
    }

    private void set(int n, int n2, boolean bl) {
        this.set(n, n2, bl ? 127.0 : 0.0);
    }

    private void set(int n, int n2, double d) {
        this.set(n, n2, (byte)(d * 127.0));
    }

    private void set(int n, int n2, SCC.Note note) {
        ((TimeFreqElement)this.tflist.get((int)n)).data[n2] = note;
    }

    private void changeTime(int n, double d) {
        this.tflist.get(n).t = d;
    }

    private void changeIsMeasureHead(int n, boolean bl) {
        this.tflist.get(n).isMeasureHead = bl;
    }

    public int length() {
        return this.tflist.size();
    }

    static int dist(TimeFreqElement timeFreqElement, TimeFreqElement timeFreqElement2) {
        return timeFreqElement.dist(timeFreqElement2);
    }

    public void println() {
        for (TimeFreqElement timeFreqElement : this.tflist) {
            System.out.println(timeFreqElement);
        }
    }

    public static TimeFreqRepresentation getTimeFreqRepresentation(SCC sCC, int n) throws TransformerException {
        return TimeFreqRepresentation.getTimeFreqRepresentation(sCC, n, 4, null);
    }

    public static TimeFreqRepresentation getTimeFreqRepresentation(SCC sCC, int n, int n2, MusicXMLWrapper musicXMLWrapper) throws TransformerException {
        SCC.Part[] partArray;
        TimeFreqRepresentation timeFreqRepresentation = new TimeFreqRepresentation(128);
        for (SCC.Part part : partArray = sCC.getPartList()) {
            SCC.Note[] noteArray;
            for (SCC.Note note : noteArray = part.getNoteOnlyList()) {
                byte by;
                int n3;
                int n4 = note.onset(n) * n2 / 4 / n;
                int n5 = note.offset(n) * n2 / 4 / n;
                int n6 = note.notenum();
                if (n4 > n5) {
                    n4 += n5;
                    n5 = n4 - n5;
                    n4 -= n5;
                }
                while ((n3 = timeFreqRepresentation.length()) <= n5) {
                    timeFreqRepresentation.addTime(n3 * n * 4 / n2);
                }
                timeFreqRepresentation.set(n4, n6, note);
                try {
                    by = (byte)note.velocity();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    by = 127;
                }
                for (int i = n4; i <= n5; ++i) {
                    timeFreqRepresentation.set(i, n6, by);
                }
            }
        }
        if (musicXMLWrapper != null) {
            int n7 = 1;
            try {
                while (true) {
                    timeFreqRepresentation.changeIsMeasureHead(musicXMLWrapper.getCumulativeTicks(n7++, n) * n2 / 4 / n, true);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
        }
        return timeFreqRepresentation;
    }

    public class TimeFreqElement {
        private byte[] values;
        private SCC.Note[] data;
        private double t;
        private boolean isMeasureHead;

        private TimeFreqElement(double d, byte[] byArray, SCC.Note[] noteArray) {
            this.values = byArray;
            this.data = noteArray;
            this.t = d;
            this.isMeasureHead = false;
        }

        public byte[] values() {
            return this.values;
        }

        int dist(TimeFreqElement timeFreqElement) {
            if (this.values.length != timeFreqElement.values.length) {
                throw new IllegalStateException();
            }
            int n = 0;
            for (int i = 0; i < this.values.length; ++i) {
                int n2 = this.values[i] - timeFreqElement.values[i];
                n += n2 >= 0 ? n2 : -n2;
            }
            return n;
        }

        int distFromZero() {
            int n = 0;
            for (int i = 0; i < this.values.length; ++i) {
                n += this.values[i] > 0 ? this.values[i] : -this.values[i];
            }
            return n;
        }

        public double time() {
            return this.t;
        }

        public SCC.Note[] data() {
            return this.data;
        }

        public boolean isMeasureHead() {
            return this.isMeasureHead;
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < this.values.length; ++i) {
                string = string + " " + this.values[i];
            }
            return string;
        }
    }
}

