/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.processing;

import java.awt.Component;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import jp.crestmuse.cmx.amusaj.sp.MidiEventSender;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.MidiOutputModule;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SynchronizedWindowSlider;
import jp.crestmuse.cmx.amusaj.sp.TappingModule;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.processing.CMXController;
import jp.crestmuse.cmx.sound.MIDIConsts;
import jp.crestmuse.cmx.sound.MusicListener;
import jp.crestmuse.cmx.sound.MusicPlaySynchronizer;
import jp.crestmuse.cmx.sound.TickTimer;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMXApplet
extends PApplet
implements MusicListener,
TickTimer,
MIDIConsts {
    private static final CMXController ctrl = CMXController.getInstance();
    private boolean autostart = true;

    public static CMXFileWrapper createDocument(String string) {
        return CMXController.createDocument(string);
    }

    public static CMXFileWrapper readfile(String string) {
        return CMXController.readfile(string);
    }

    public static CMXFileWrapper read(InputStream inputStream) {
        return CMXController.read(inputStream);
    }

    public static MIDIXMLWrapper readSMFAsMIDIXML(String string) {
        return CMXController.readSMFAsMIDIXML(string);
    }

    public static MIDIXMLWrapper readSMFAsMIDIXML(InputStream inputStream) {
        return CMXController.readSMFAsMIDIXML(inputStream);
    }

    public void writefile(CMXFileWrapper cMXFileWrapper, String string) {
        CMXController.writefile(cMXFileWrapper, string);
    }

    public void write(CMXFileWrapper cMXFileWrapper, OutputStream outputStream) {
        CMXController.write(cMXFileWrapper, outputStream);
    }

    public void writefileAsSMF(SCCXMLWrapper sCCXMLWrapper, String string) {
        CMXController.writefileAsSMF(sCCXMLWrapper, string);
    }

    public void writefileAsSMF(MIDIXMLWrapper mIDIXMLWrapper, String string) {
        CMXController.writefileAsSMF(mIDIXMLWrapper, string);
    }

    public void writeAsSMF(SCCXMLWrapper sCCXMLWrapper, OutputStream outputStream) {
        CMXController.writeAsSMF(sCCXMLWrapper, outputStream);
    }

    public void writeAsSMF(MIDIXMLWrapper mIDIXMLWrapper, OutputStream outputStream) {
        CMXController.writeAsSMF(mIDIXMLWrapper, outputStream);
    }

    public void println(CMXFileWrapper cMXFileWrapper) {
        CMXController.println(cMXFileWrapper);
    }

    public void addSPModule(ProducerConsumerCompatible producerConsumerCompatible) {
        ctrl.addSPModule(producerConsumerCompatible);
    }

    public void connect(ProducerConsumerCompatible producerConsumerCompatible, int n, ProducerConsumerCompatible producerConsumerCompatible2, int n2) {
        ctrl.connect(producerConsumerCompatible, n, producerConsumerCompatible2, n2);
    }

    public void wavread(String string) {
        ctrl.wavread(string);
        ctrl.addMusicListener(this);
    }

    public void mp3read(String string) {
        ctrl.mp3read(string);
        ctrl.addMusicListener(this);
    }

    public void smfread(String string) {
        ctrl.smfread(string);
        ctrl.addMusicListener(this);
    }

    public void smfread(MIDIXMLWrapper mIDIXMLWrapper) {
        ctrl.smfread(mIDIXMLWrapper);
        ctrl.addMusicListener(this);
    }

    public void smfread(SCCXMLWrapper sCCXMLWrapper) {
        ctrl.smfread(sCCXMLWrapper);
        ctrl.addMusicListener(this);
    }

    public void playMusic() {
        ctrl.playMusic();
    }

    public void stopMusic() {
        ctrl.stopMusic();
    }

    public boolean isNowPlaying() {
        return ctrl.isNowPlaying();
    }

    public void setMusicLoop(boolean bl) {
        ctrl.setMusicLoop(bl);
    }

    public long getMicrosecondPosition() {
        return ctrl.getMicrosecondPosition();
    }

    public void setMicrosecondPosition(long l) {
        ctrl.setMicrosecondPosition(l);
    }

    @Override
    public long getTickPosition() {
        return ctrl.getTickPosition();
    }

    @Override
    public int getTicksPerBeat() {
        return ctrl.getTicksPerBeat();
    }

    @Override
    public void musicStarted(MusicPlaySynchronizer musicPlaySynchronizer) {
        this.musicStarted();
    }

    @Override
    public void musicStopped(MusicPlaySynchronizer musicPlaySynchronizer) {
        this.musicStopped();
    }

    @Override
    public void synchronize(double d, long l, MusicPlaySynchronizer musicPlaySynchronizer) {
        this.synchronize();
    }

    protected void musicStarted() {
    }

    protected void musicStopped() {
    }

    protected void synchronize() {
    }

    public MidiInputModule createVirtualKeyboard() {
        if (this instanceof Component) {
            return ctrl.createVirtualKeyboard((Component)((Object)this));
        }
        return ctrl.createVirtualKeyboard();
    }

    public MidiInputModule createMidiIn() {
        return ctrl.createMidiIn();
    }

    public MidiOutputModule createMidiOut() {
        return ctrl.createMidiOut();
    }

    public void showAudioMixerChooser() {
        ctrl.showAudioMixerChooser((Component)((Object)this));
    }

    public void showMidiInChooser() {
        ctrl.showMidiInChooser((Component)((Object)this));
    }

    public void showMidiOutChooser() {
        ctrl.showMidiOutChooser((Component)((Object)this));
    }

    public WindowSlider createMic() {
        return ctrl.createMic();
    }

    public WindowSlider createMic(int n) {
        return ctrl.createMic(n);
    }

    public void closeMic() {
        ctrl.closeMic();
    }

    public SynchronizedWindowSlider createWaveCapture(boolean bl) {
        return ctrl.createWaveCapture(bl);
    }

    public void readConfig(String string) {
        ctrl.readConfig(string);
    }

    public void readConfig(InputStream inputStream) {
        ctrl.readConfig(inputStream);
    }

    public MidiEventSender createMidiEventSender() {
        return ctrl.createMidiEventSender();
    }

    public void handleDraw() {
        if (this.frameCount == 1) {
            this.autostart();
            super.handleDraw();
        } else {
            super.handleDraw();
        }
    }

    private void autostart() {
        if (this.autostart) {
            CMXApplet.println((String)"SPExector automatically started.");
            ctrl.startSP();
        }
    }

    public static void main(String string) {
        CMXApplet.main((String[])new String[]{string});
    }

    public static void start(String string) {
        CMXApplet.main((String[])new String[]{string});
    }

    public static MusicRepresentation createMusicRepresentation(int n, int n2) {
        return CMXController.createMusicRepresentation(n, n2);
    }

    public static MidiEventWithTicktime createShortMessageEvent(byte[] byArray, long l, long l2) {
        return CMXController.createShortMessageEvent(byArray, l, l2);
    }

    public static MidiEventWithTicktime createShortMessageEvent(List<? extends Number> list, long l, long l2) {
        return CMXController.createShortMessageEvent(list, l, l2);
    }

    public static MidiEventWithTicktime createControlChangeEvent(long l, int n, int n2, int n3) {
        return CMXController.createControlChangeEvent(l, n, n2, n3);
    }

    public static MidiEventWithTicktime createNoteOffEvent(long l, int n, int n2, int n3) {
        return CMXController.createNoteOffEvent(l, n, n2, n3);
    }

    public static MidiEventWithTicktime createNoteOnEvent(long l, int n, int n2, int n3) {
        return CMXController.createNoteOnEvent(l, n, n2, n3);
    }

    public static MidiEventWithTicktime createProgramChangeEvent(long l, int n, int n2) {
        return CMXController.createProgramChangeEvent(l, n, n2);
    }

    public TappingModule createTappingModule() {
        return ctrl.createTappingModule((Component)((Object)this));
    }

    public void sleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void line(double d, double d2, double d3, double d4) {
        this.line((float)d, (float)d2, (float)d3, (float)d4);
    }

    public void rect(double d, double d2, double d3, double d4) {
        this.rect((float)d, (float)d2, (float)d3, (float)d4);
    }

    public void textSize(double d) {
        this.textSize((float)d);
    }
}

