/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.processing;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.DecoderException;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.MidiEventSender;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.MidiOutputModule;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.SynchronizedWindowSlider;
import jp.crestmuse.cmx.amusaj.sp.TappingModule;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MP3Wrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.filewrappers.WAVWrapper;
import jp.crestmuse.cmx.filewrappers.XMLException;
import jp.crestmuse.cmx.inference.MusicRepresentation;
import jp.crestmuse.cmx.inference.MusicRepresentationFactory;
import jp.crestmuse.cmx.processing.DeviceNotAvailableException;
import jp.crestmuse.cmx.sound.AudioDataCompatible;
import jp.crestmuse.cmx.sound.AudioInputStreamWrapper;
import jp.crestmuse.cmx.sound.MIDIConsts;
import jp.crestmuse.cmx.sound.MusicListener;
import jp.crestmuse.cmx.sound.MusicPlaySynchronizer;
import jp.crestmuse.cmx.sound.MusicPlayer;
import jp.crestmuse.cmx.sound.SMFPlayer;
import jp.crestmuse.cmx.sound.SoundUtils;
import jp.crestmuse.cmx.sound.TickTimer;
import jp.crestmuse.cmx.sound.VirtualKeyboard;
import jp.crestmuse.cmx.sound.WAVPlayer;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMXController
implements TickTimer,
MIDIConsts {
    private static final CMXController me = new CMXController();
    private SPExecutor spexec = null;
    private MusicPlayer[] musicPlayer = new MusicPlayer[256];
    private MusicPlaySynchronizer[] musicSync = new MusicPlaySynchronizer[256];
    private AudioInputStreamWrapper mic = null;
    private AudioDataCompatible wav = null;
    private MidiDevice.Info midiin = null;
    private MidiDevice.Info midiout = null;
    private Mixer.Info mixer = null;

    private CMXController() {
    }

    public static CMXController getInstance() {
        return me;
    }

    public static CMXFileWrapper createDocument(String string) {
        try {
            return CMXFileWrapper.createDocument(string);
        }
        catch (InvalidFileTypeException invalidFileTypeException) {
            throw new IllegalArgumentException("Invalid file type: " + string);
        }
    }

    public static CMXFileWrapper readfile(String string) {
        try {
            return CMXFileWrapper.readfile(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read file: " + string);
        }
    }

    public static CMXFileWrapper read(InputStream inputStream) {
        try {
            return CMXFileWrapper.read(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read file");
        }
    }

    public static MIDIXMLWrapper readSMFAsMIDIXML(String string) {
        try {
            return MIDIXMLWrapper.readSMF(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read file: " + string);
        }
        catch (TransformerException transformerException) {
            throw new XMLException(transformerException);
        }
        catch (SAXException sAXException) {
            throw new XMLException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
    }

    public static MIDIXMLWrapper readSMFAsMIDIXML(InputStream inputStream) {
        try {
            return MIDIXMLWrapper.readSMF(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read file");
        }
        catch (TransformerException transformerException) {
            throw new XMLException(transformerException);
        }
        catch (SAXException sAXException) {
            throw new XMLException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
    }

    public static void writefile(CMXFileWrapper cMXFileWrapper, String string) {
        try {
            cMXFileWrapper.writefile(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot write file: " + string);
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("XML error: " + string);
        }
    }

    public static void write(CMXFileWrapper cMXFileWrapper, OutputStream outputStream) {
        try {
            cMXFileWrapper.write(outputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot write file");
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("XML error");
        }
    }

    public static void writefileAsSMF(SCCXMLWrapper sCCXMLWrapper, String string) {
        try {
            sCCXMLWrapper.toMIDIXML().writefile(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot write file: " + string);
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("XML error: " + string);
        }
    }

    public static void writefileAsSMF(MIDIXMLWrapper mIDIXMLWrapper, String string) {
        try {
            mIDIXMLWrapper.writefile(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot write file: " + string);
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("XML error: " + string);
        }
    }

    public static void writeAsSMF(SCCXMLWrapper sCCXMLWrapper, OutputStream outputStream) {
        try {
            sCCXMLWrapper.toMIDIXML().write(outputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot write file");
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("XML error");
        }
    }

    public static void writeAsSMF(MIDIXMLWrapper mIDIXMLWrapper, OutputStream outputStream) {
        try {
            mIDIXMLWrapper.write(outputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot write file");
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("XML error");
        }
    }

    public static void println(CMXFileWrapper cMXFileWrapper) {
        try {
            cMXFileWrapper.write(System.out);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("I/O Error");
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("XML error");
        }
    }

    public void addSPModule(ProducerConsumerCompatible producerConsumerCompatible) {
        if (this.spexec == null) {
            this.spexec = new SPExecutor();
        }
        this.spexec.addSPModule(producerConsumerCompatible);
    }

    public void connect(ProducerConsumerCompatible producerConsumerCompatible, int n, ProducerConsumerCompatible producerConsumerCompatible2, int n2) {
        this.spexec.connect(producerConsumerCompatible, n, producerConsumerCompatible2, n2);
    }

    public void startSP() {
        if (this.mic != null) {
            this.mic.getLine().start();
        }
        if (this.spexec != null) {
            this.spexec.start();
        }
    }

    public void wavread(AudioDataCompatible audioDataCompatible) {
        this.wavread(0, audioDataCompatible);
    }

    public void wavread(int n, AudioDataCompatible audioDataCompatible) {
        try {
            this.wav = audioDataCompatible;
            this.musicPlayer[n] = new WAVPlayer(this.wav);
            this.musicSync[n] = new MusicPlaySynchronizer(this.musicPlayer[n]);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new DeviceNotAvailableException("Audio device not available");
        }
    }

    public void wavread(String string) {
        this.wavread(0, string);
    }

    public void wavread(int n, String string) {
        try {
            this.wav = WAVWrapper.readfile(string);
            this.musicPlayer[n] = new WAVPlayer(this.wav);
            this.musicSync[n] = new MusicPlaySynchronizer(this.musicPlayer[n]);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read file: " + string);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new DeviceNotAvailableException("Audio device not available");
        }
    }

    public void wavread(InputStream inputStream) {
        this.wavread(0, inputStream);
    }

    public void wavread(int n, InputStream inputStream) {
        try {
            this.wav = WAVWrapper.read(inputStream);
            this.musicPlayer[n] = new WAVPlayer(this.wav);
            this.musicSync[n] = new MusicPlaySynchronizer(this.musicPlayer[n]);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read file");
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new DeviceNotAvailableException("Audio device not available");
        }
    }

    public void mp3read(String string) {
        this.mp3read(0, string);
    }

    public void mp3read(int n, String string) {
        try {
            this.wav = MP3Wrapper.readfile(string);
            this.musicPlayer[n] = new WAVPlayer(this.wav);
            this.musicSync[n] = new MusicPlaySynchronizer(this.musicPlayer[n]);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Cannot read file: " + string);
        }
        catch (DecoderException decoderException) {
            throw new IllegalStateException("Cannot decode MP3 file: " + string);
        }
        catch (BitstreamException bitstreamException) {
            throw new IllegalStateException("Cannot decode MP3 file: " + string);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new DeviceNotAvailableException("Audio device not available");
        }
    }

    public void mp3read(int n, InputStream inputStream) {
        try {
            this.wav = MP3Wrapper.read(inputStream);
            this.musicPlayer[n] = new WAVPlayer(this.wav);
            this.musicSync[n] = new MusicPlaySynchronizer(this.musicPlayer[n]);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Cannot read file");
        }
        catch (DecoderException decoderException) {
            throw new IllegalStateException("Cannot decode MP3 file");
        }
        catch (BitstreamException bitstreamException) {
            throw new IllegalStateException("Cannot decode MP3 file");
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new DeviceNotAvailableException("Audio device not available");
        }
    }

    public void smfread(String string) {
        this.smfread(0, string);
    }

    public void smfread(int n, String string) {
        try {
            if (this.midiout == null) {
                this.musicPlayer[n] = new SMFPlayer();
            } else {
                MidiDevice midiDevice = SoundUtils.getMidiOutDeviceByName(this.midiout.getName());
                midiDevice.open();
                this.musicPlayer[n] = new SMFPlayer(midiDevice);
            }
            ((SMFPlayer)this.musicPlayer[n]).readSMF(string);
            this.musicSync[n] = new MusicPlaySynchronizer(this.musicPlayer[n]);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read file: " + string);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new IllegalArgumentException("Invalid MIDI data: " + string);
        }
    }

    public void smfread(InputStream inputStream) {
        this.smfread(0, inputStream);
    }

    public void smfread(int n, Sequence sequence) {
        try {
            if (this.midiout == null) {
                this.musicPlayer[n] = new SMFPlayer();
            } else {
                MidiDevice midiDevice = SoundUtils.getMidiOutDeviceByName(this.midiout.getName());
                midiDevice.open();
                this.musicPlayer[n] = new SMFPlayer(midiDevice);
            }
            ((SMFPlayer)this.musicPlayer[n]).readSMF(sequence);
            this.musicSync[n] = new MusicPlaySynchronizer(this.musicPlayer[n]);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new IllegalArgumentException("Invalid MIDI data");
        }
    }

    public void smfread(Sequence sequence) {
        this.smfread(0, sequence);
    }

    public void smfread(int n, InputStream inputStream) {
        try {
            if (this.midiout == null) {
                this.musicPlayer[n] = new SMFPlayer();
            } else {
                MidiDevice midiDevice = SoundUtils.getMidiOutDeviceByName(this.midiout.getName());
                midiDevice.open();
                this.musicPlayer[n] = new SMFPlayer(midiDevice);
            }
            ((SMFPlayer)this.musicPlayer[n]).readSMF(inputStream);
            this.musicSync[n] = new MusicPlaySynchronizer(this.musicPlayer[n]);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read file");
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new IllegalArgumentException("Invalid MIDI data");
        }
    }

    public void smfread(MIDIXMLWrapper mIDIXMLWrapper) {
        this.smfread(0, mIDIXMLWrapper);
    }

    public void smfread(int n, MIDIXMLWrapper mIDIXMLWrapper) {
        try {
            this.smfread(n, mIDIXMLWrapper.getMIDIInputStream());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Invalid MIDIXML data");
        }
    }

    public void smfread(SCCXMLWrapper sCCXMLWrapper) {
        this.smfread(0, sCCXMLWrapper);
    }

    public void smfread(int n, SCCXMLWrapper sCCXMLWrapper) {
        try {
            this.smfread(n, sCCXMLWrapper.getMIDIInputStream());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Invalid SCCXML data");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("parser error");
        }
        catch (TransformerException transformerException) {
            throw new IllegalArgumentException("XML error");
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("XML error");
        }
    }

    public void playMusic() {
        this.playMusic(0);
    }

    public void playMusic(int n) {
        this.musicSync[n].play();
    }

    public void stopMusic() {
        this.stopMusic(0);
    }

    public void stopMusic(int n) {
        this.musicSync[n].stop();
    }

    public boolean isNowPlaying() {
        return this.isNowPlaying(0);
    }

    public boolean isNowPlaying(int n) {
        return this.musicPlayer[n] != null && this.musicPlayer[n].isNowPlaying();
    }

    public void setMusicLoop(boolean bl) {
        this.setMusicLoop(0, bl);
    }

    public void setMusicLoop(int n, boolean bl) {
        if (this.musicPlayer[n] == null) {
            throw new IllegalStateException("setMusicLoop should be called after a music file is read.");
        }
        this.musicPlayer[n].setLoopEnabled(bl);
    }

    public void setMicrosecondPosition(long l) {
        this.setMicrosecondPosition(0, l);
    }

    public void setMicrosecondPosition(int n, long l) {
        this.musicPlayer[n].setMicrosecondPosition(0L);
    }

    public long getMicrosecondPosition() {
        return this.getMicrosecondPosition(0);
    }

    public long getMicrosecondPosition(int n) {
        if (this.musicPlayer[n] == null) {
            return 0L;
        }
        return this.musicPlayer[n].getMicrosecondPosition();
    }

    @Override
    public long getTickPosition() {
        return this.getTickPosition(0);
    }

    public long getTickPosition(int n) {
        if (this.musicPlayer[n] == null) {
            return 0L;
        }
        return this.musicPlayer[n].getTickPosition();
    }

    @Override
    public int getTicksPerBeat() {
        return this.getTicksPerBeat(0);
    }

    public int getTicksPerBeat(int n) {
        if (this.musicPlayer[n] == null) {
            return 0;
        }
        return this.musicPlayer[n].getTicksPerBeat();
    }

    public void addMusicListener(MusicListener musicListener) {
        this.addMusicListener(0, musicListener);
    }

    public void addMusicListener(int n, MusicListener musicListener) {
        this.musicSync[n].addMusicListener(musicListener);
    }

    public void waitForMusicStopped() {
        this.waitForMusicStopped(0);
    }

    public void waitForMusicStopped(int n) {
        try {
            while (this.isNowPlaying(n)) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public MidiInputModule createVirtualKeyboard() {
        try {
            VirtualKeyboard virtualKeyboard = new VirtualKeyboard();
            MidiInputModule midiInputModule = new MidiInputModule(virtualKeyboard);
            midiInputModule.setTickTimer(this);
            return midiInputModule;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
    }

    public MidiInputModule createVirtualKeyboard(Component component) {
        try {
            VirtualKeyboard virtualKeyboard = new VirtualKeyboard(component);
            MidiInputModule midiInputModule = new MidiInputModule(virtualKeyboard);
            return midiInputModule;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
    }

    public MidiInputModule createMidiIn() {
        try {
            if (this.midiin == null) {
                throw new IllegalStateException("MIDI IN device has not been selected yet");
            }
            return new MidiInputModule(SoundUtils.getMidiInDeviceByName(this.midiin.getName()));
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
    }

    public MidiOutputModule createMidiOut() {
        try {
            if (this.midiout == null) {
                return new MidiOutputModule();
            }
            MidiDevice midiDevice = SoundUtils.getMidiOutDeviceByName(this.midiout.getName());
            midiDevice.open();
            return new MidiOutputModule(midiDevice);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
    }

    public void showAudioMixerChooser(Component component) {
        Object object = JOptionPane.showInputDialog(component, "Select Audio Mixer.", "Select Audio Mixer...", -1, null, AudioSystem.getMixerInfo(), null);
        if (object != null) {
            this.mixer = (Mixer.Info)object;
        }
    }

    public void showMidiInChooser(Component component) {
        try {
            Object object = JOptionPane.showInputDialog(component, "Select MIDI IN Device.", "Select MIDI IN Device...", -1, null, SoundUtils.getMidiInDeviceInfo().toArray(), null);
            if (object != null) {
                this.midiin = (MidiDevice.Info)object;
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
    }

    public void showMidiOutChooser(Component component) {
        try {
            Object object = JOptionPane.showInputDialog(component, "Select MIDI OUT Device.", "Select MIDI OUT Device...", -1, null, SoundUtils.getMidiOutDeviceInfo().toArray(), null);
            if (object != null) {
                this.midiout = (MidiDevice.Info)object;
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new DeviceNotAvailableException("MIDI device not available");
        }
    }

    public WindowSlider createMic() {
        return this.createMic(16000);
    }

    public WindowSlider createMic(int n) {
        try {
            this.mic = AudioInputStreamWrapper.createWrapper16(n, this.mixer);
            WindowSlider windowSlider = new WindowSlider(false);
            windowSlider.setInputData(this.mic);
            windowSlider.setTickTimer(this);
            return windowSlider;
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new DeviceNotAvailableException("Audio device not available");
        }
    }

    public void closeMic() {
        if (this.mic != null) {
            this.mic.getLine().close();
        }
    }

    public SynchronizedWindowSlider createWaveCapture(boolean bl) {
        SynchronizedWindowSlider synchronizedWindowSlider = new SynchronizedWindowSlider(bl);
        synchronizedWindowSlider.setInputData(this.wav);
        this.addMusicListener(synchronizedWindowSlider);
        return synchronizedWindowSlider;
    }

    public MidiEventSender createMidiEventSender() {
        return new MidiEventSender();
    }

    public void readConfig(String string) {
        try {
            AmusaParameterSet.getInstance().setAnotherParameterSet((ConfigXMLWrapper)CMXFileWrapper.readfile(string));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read config file: " + string);
        }
    }

    public void readConfig(InputStream inputStream) {
        try {
            AmusaParameterSet.getInstance().setAnotherParameterSet((ConfigXMLWrapper)CMXFileWrapper.read(inputStream));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot read config file");
        }
    }

    public static MusicRepresentation createMusicRepresentation(int n, int n2) {
        return MusicRepresentationFactory.create(n, n2);
    }

    public static MidiEventWithTicktime createShortMessageEvent(byte[] byArray, long l, long l2) {
        return MidiEventWithTicktime.createShortMessageEvent(byArray, l, l2);
    }

    public static MidiEventWithTicktime createShortMessageEvent(List<? extends Number> list, long l, long l2) {
        return MidiEventWithTicktime.createShortMessageEvent(list, l, l2);
    }

    public static MidiEventWithTicktime createControlChangeEvent(long l, int n, int n2, int n3) {
        return MidiEventWithTicktime.createControlChangeEvent(l, n, n2, n3);
    }

    public static MidiEventWithTicktime createNoteOffEvent(long l, int n, int n2, int n3) {
        return MidiEventWithTicktime.createNoteOffEvent(l, n, n2, n3);
    }

    public static MidiEventWithTicktime createNoteOnEvent(long l, int n, int n2, int n3) {
        return MidiEventWithTicktime.createNoteOnEvent(l, n, n2, n3);
    }

    public static MidiEventWithTicktime createProgramChangeEvent(long l, int n, int n2) {
        return MidiEventWithTicktime.createProgramChangeEvent(l, n, n2);
    }

    public TappingModule createTappingModule(Component component) {
        TappingModule tappingModule = new TappingModule();
        tappingModule.setTickTimer(this);
        component.addKeyListener(tappingModule);
        return tappingModule;
    }

    public void sleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

