/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.sound.AudioDataCompatible;

public class AudioInputStreamWrapper
implements AudioDataCompatible {
    private TargetDataLine line;
    private AudioInputStream audioin;
    private AudioFormat fmt;
    private int channels;
    private int sampleRate;
    private int bitsPerSample;
    private int bytesPerSample;
    private byte[] buff = null;
    private double[] cache = null;
    private int next = 0;
    private static final int CACHE_SIZE = 65536;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    public AudioInputStreamWrapper(InputStream inputStream, AudioFormat audioFormat, long l) {
        this.line = null;
        this.audioin = new AudioInputStream(inputStream, audioFormat, l);
        this.fmt = audioFormat;
        this.channels = audioFormat.getChannels();
        this.sampleRate = (int)audioFormat.getSampleRate();
        this.bitsPerSample = audioFormat.getSampleSizeInBits();
        this.bytesPerSample = this.bitsPerSample / 8;
    }

    AudioInputStreamWrapper(TargetDataLine targetDataLine) {
        this.line = targetDataLine;
        this.audioin = new AudioInputStream(targetDataLine);
        this.fmt = this.audioin.getFormat();
        this.channels = this.fmt.getChannels();
        this.sampleRate = (int)this.fmt.getSampleRate();
        this.bitsPerSample = this.fmt.getSampleSizeInBits();
        this.bytesPerSample = this.bitsPerSample / 8;
    }

    public AudioInputStream getAudioInputStream() {
        return this.audioin;
    }

    public TargetDataLine getLine() {
        return this.line;
    }

    public int channels() {
        return this.channels;
    }

    public int sampleRate() {
        return this.sampleRate;
    }

    public AudioFormat getAudioFormat() {
        return this.fmt;
    }

    public DoubleArray[] getDoubleArrayWaveform() {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteArrayWaveform() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    public DoubleArray[] read(long l, int n) {
        throw new UnsupportedOperationException();
    }

    public DoubleArray[] readNext(int n, int n2) throws IOException {
        int n3;
        int n4;
        DoubleArray[] doubleArrayArray = new DoubleArray[this.channels];
        for (n4 = 0; n4 < doubleArrayArray.length; ++n4) {
            doubleArrayArray[n4] = factory.createArray(n);
        }
        if (this.cache == null) {
            this.cache = new double[65536];
            n2 = 0;
        }
        n4 = n - n2;
        if (this.buff == null || this.buff.length < n4 * this.channels) {
            this.buff = new byte[this.bytesPerSample * n4 * this.channels];
        }
        for (int i = 0; i < n2; ++i) {
            for (n3 = 0; n3 < this.channels; ++n3) {
                doubleArrayArray[n3].set(i, this.cache[this.next + (i - n2) * this.channels + n3]);
            }
        }
        this.audioin.read(this.buff, 0, this.bytesPerSample * n4 * this.channels);
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buff);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i = 0; i < this.channels; ++i) {
                if (this.bitsPerSample == 8) {
                    int n5 = byteBuffer.get() + 128;
                    if (n5 >= 128) {
                        n5 -= 256;
                    }
                    this.cache[this.next + n3 * this.channels + i] = (double)n5 / 256.0;
                } else if (this.bitsPerSample == 16) {
                    this.cache[this.next + n3 * this.channels + i] = (double)byteBuffer.getShort() / 65536.0;
                } else {
                    throw new UnsupportedOperationException("Unsupported audio format: " + this.fmt);
                }
                doubleArrayArray[i].set(n2 + n3, this.cache[this.next + n3 * this.channels + i]);
            }
        }
        this.next += n4 * this.channels;
        if (this.next >= 65536 - n) {
            System.arraycopy(this.cache, this.next - n, this.cache, 0, n);
            this.next = n;
        }
        return doubleArrayArray;
    }

    public boolean hasNext(int n) {
        return this.line != null ? this.line.isOpen() : true;
    }

    public static AudioInputStreamWrapper createWrapper8(int n, Mixer.Info info) throws LineUnavailableException {
        TargetDataLine targetDataLine;
        Object object;
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, n, 8, 1, 1, n, true);
        DataLine.Info info2 = new DataLine.Info(TargetDataLine.class, audioFormat);
        if (info != null) {
            object = AudioSystem.getMixer(info);
            targetDataLine = (TargetDataLine)object.getLine(info2);
        } else {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info2);
        }
        targetDataLine.open(audioFormat);
        object = new AudioInputStreamWrapper(targetDataLine);
        return object;
    }

    public static AudioInputStreamWrapper createWrapper16(int n, Mixer.Info info) throws LineUnavailableException {
        TargetDataLine targetDataLine;
        Object object;
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, n, 16, 1, 2, n, false);
        DataLine.Info info2 = new DataLine.Info(TargetDataLine.class, audioFormat);
        if (info != null) {
            object = AudioSystem.getMixer(info);
            targetDataLine = (TargetDataLine)object.getLine(info2);
        } else {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info2);
        }
        targetDataLine.open(audioFormat);
        object = new AudioInputStreamWrapper(targetDataLine);
        return object;
    }
}

