/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BinaryDoubleExpressionHelper;
import org.codehaus.groovy.classgen.asm.BinaryExpressionHelper;
import org.codehaus.groovy.classgen.asm.BinaryExpressionWriter;
import org.codehaus.groovy.classgen.asm.BinaryFloatExpressionHelper;
import org.codehaus.groovy.classgen.asm.BinaryIntExpressionHelper;
import org.codehaus.groovy.classgen.asm.BinaryLongExpressionHelper;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.MethodCaller;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.objectweb.asm.MethodVisitor;

public class BinaryExpressionMultiTypeDispatcher
extends BinaryExpressionHelper {
    private BinaryExpressionWriter[] binExpWriter = new BinaryExpressionWriter[]{new DummyHelper(this.getController()), new BinaryIntExpressionHelper(this.getController()), new BinaryLongExpressionHelper(this.getController()), new BinaryDoubleExpressionHelper(this.getController()), new BinaryCharExpressionHelper(this.getController()), new BinaryByteExpressionHelper(this.getController()), new BinaryShortExpressionHelper(this.getController()), new BinaryFloatExpressionHelper(this.getController())};
    protected static Map<ClassNode, Integer> typeMap = new HashMap<ClassNode, Integer>(14);
    protected static final String[] typeMapKeyNames;

    public BinaryExpressionMultiTypeDispatcher(WriterController wc) {
        super(wc);
    }

    protected static ClassNode getType(Expression exp, ClassNode current) {
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)exp.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        ClassNode type = null;
        if (meta != null) {
            type = meta.type;
        }
        if (type != null) {
            return type;
        }
        if (exp instanceof VariableExpression) {
            FieldNode fn;
            VariableExpression ve = (VariableExpression)exp;
            if (ve.isClosureSharedVariable()) {
                return ve.getType();
            }
            type = ve.getOriginType();
            if (ve.getAccessedVariable() instanceof FieldNode && !(fn = (FieldNode)ve.getAccessedVariable()).getDeclaringClass().equals(current)) {
                return ClassHelper.OBJECT_TYPE;
            }
        } else if (exp instanceof Variable) {
            Variable v = (Variable)((Object)exp);
            type = v.getOriginType();
        } else {
            type = exp.getType();
        }
        return type.redirect();
    }

    protected static boolean isIntCategory(ClassNode type) {
        return type == ClassHelper.int_TYPE || type == ClassHelper.char_TYPE || type == ClassHelper.byte_TYPE || type == ClassHelper.short_TYPE;
    }

    protected static boolean isLongCategory(ClassNode type) {
        return type == ClassHelper.long_TYPE || BinaryExpressionMultiTypeDispatcher.isIntCategory(type);
    }

    protected static boolean isDoubleCategory(ClassNode type) {
        return type == ClassHelper.float_TYPE || type == ClassHelper.double_TYPE || BinaryExpressionMultiTypeDispatcher.isLongCategory(type);
    }

    private int getOperandConversionType(ClassNode leftType, ClassNode rightType) {
        if (BinaryExpressionMultiTypeDispatcher.isIntCategory(leftType) && BinaryExpressionMultiTypeDispatcher.isIntCategory(rightType)) {
            return 1;
        }
        if (BinaryExpressionMultiTypeDispatcher.isLongCategory(leftType) && BinaryExpressionMultiTypeDispatcher.isLongCategory(rightType)) {
            return 2;
        }
        if (BinaryExpressionMultiTypeDispatcher.isDoubleCategory(leftType) && BinaryExpressionMultiTypeDispatcher.isDoubleCategory(rightType)) {
            return 3;
        }
        return 0;
    }

    private int getOperandType(ClassNode type) {
        Integer ret = typeMap.get(type);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    protected void evaluateCompareExpression(MethodCaller compareMethod, BinaryExpression binExp) {
        Expression rightExp;
        ClassNode rightType;
        ClassNode current = this.getController().getClassNode();
        int operation = binExp.getOperation().getType();
        Expression leftExp = binExp.getLeftExpression();
        ClassNode leftType = BinaryExpressionMultiTypeDispatcher.getType(leftExp, current);
        int operationType = this.getOperandConversionType(leftType, rightType = BinaryExpressionMultiTypeDispatcher.getType(rightExp = binExp.getRightExpression(), current));
        BinaryExpressionWriter bew = this.binExpWriter[operationType];
        if (bew.write(operation, true)) {
            AsmClassGenerator acg = this.getController().getAcg();
            OperandStack os = this.getController().getOperandStack();
            leftExp.visit(acg);
            os.doGroovyCast(bew.getNormalOpResultType());
            rightExp.visit(acg);
            os.doGroovyCast(bew.getNormalOpResultType());
            bew.write(operation, false);
        } else {
            super.evaluateCompareExpression(compareMethod, binExp);
        }
    }

    protected void evaluateBinaryExpression(String message, BinaryExpression binExp) {
        ClassNode leftTypeOrig;
        int operation = binExp.getOperation().getType();
        ClassNode current = this.getController().getClassNode();
        Expression leftExp = binExp.getLeftExpression();
        ClassNode leftType = leftTypeOrig = BinaryExpressionMultiTypeDispatcher.getType(leftExp, current);
        Expression rightExp = binExp.getRightExpression();
        ClassNode rightType = BinaryExpressionMultiTypeDispatcher.getType(rightExp, current);
        if (operation == 30) {
            leftType = leftTypeOrig.getComponentType();
        }
        int operationType = this.getOperandConversionType(leftType, rightType);
        BinaryExpressionWriter bew = this.binExpWriter[operationType];
        AsmClassGenerator acg = this.getController().getAcg();
        OperandStack os = this.getController().getOperandStack();
        if (bew.arrayGet(operation, true)) {
            leftExp.visit(acg);
            os.doGroovyCast(leftTypeOrig);
            rightExp.visit(acg);
            os.doGroovyCast(ClassHelper.int_TYPE);
            bew.arrayGet(operation, false);
            os.doGroovyCast(bew.getArrayGetResultType());
        } else if (bew.write(operation, true)) {
            leftExp.visit(acg);
            os.doGroovyCast(bew.getNormalOpResultType());
            rightExp.visit(acg);
            os.doGroovyCast(bew.getNormalOpResultType());
            bew.write(operation, false);
        } else {
            super.evaluateBinaryExpression(message, binExp);
        }
    }

    private boolean isAssignmentToArray(BinaryExpression binExp) {
        Expression leftExpression = binExp.getLeftExpression();
        if (!(leftExpression instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression leftBinExpr = (BinaryExpression)leftExpression;
        return leftBinExpr.getOperation().getType() == 30;
    }

    private int removeAssignment(int op) {
        switch (op) {
            case 210: {
                return 200;
            }
            case 211: {
                return 201;
            }
            case 212: {
                return 202;
            }
        }
        return op;
    }

    protected void evaluateBinaryExpressionWithAssignment(String method, BinaryExpression binExp) {
        Expression rightExp;
        ClassNode rightType;
        if (!this.isAssignmentToArray(binExp)) {
            super.evaluateBinaryExpressionWithAssignment(method, binExp);
            return;
        }
        ClassNode current = this.getController().getClassNode();
        int operation = this.removeAssignment(binExp.getOperation().getType());
        Expression leftExp = binExp.getLeftExpression();
        ClassNode leftType = BinaryExpressionMultiTypeDispatcher.getType(leftExp, current);
        int operationType = this.getOperandConversionType(leftType, rightType = BinaryExpressionMultiTypeDispatcher.getType(rightExp = binExp.getRightExpression(), current));
        BinaryExpressionWriter bew = this.binExpWriter[operationType];
        boolean simulationSuccess = bew.arrayGet(30, true);
        simulationSuccess = simulationSuccess && bew.write(operation, true);
        boolean bl = simulationSuccess = simulationSuccess && bew.arraySet(true);
        if (!simulationSuccess) {
            super.evaluateBinaryExpressionWithAssignment(method, binExp);
            return;
        }
        AsmClassGenerator acg = this.getController().getAcg();
        OperandStack operandStack = this.getController().getOperandStack();
        CompileStack compileStack = this.getController().getCompileStack();
        BinaryExpression arrayWithSubscript = (BinaryExpression)leftExp;
        Expression subscript = arrayWithSubscript.getRightExpression();
        subscript.visit(acg);
        operandStack.doGroovyCast(ClassHelper.int_TYPE);
        int subscriptValueId = compileStack.defineTemporaryVariable("$sub", ClassHelper.int_TYPE, true);
        arrayWithSubscript.getLeftExpression().visit(acg);
        operandStack.dup();
        operandStack.load(ClassHelper.int_TYPE, subscriptValueId);
        bew.arrayGet(30, false);
        operandStack.replace(leftType, 2);
        binExp.getRightExpression().visit(acg);
        bew.write(operation, false);
        operandStack.dup();
        int resultValueId = compileStack.defineTemporaryVariable("$result", rightType, true);
        operandStack.load(ClassHelper.int_TYPE, subscriptValueId);
        operandStack.swap();
        bew.arraySet(false);
        operandStack.remove(2);
        operandStack.load(rightType, resultValueId);
        compileStack.removeVar(resultValueId);
        compileStack.removeVar(subscriptValueId);
    }

    protected void assignToArray(Expression orig, Expression receiver, Expression index, Expression rhsValueLoader) {
        ClassNode current = this.getController().getClassNode();
        ClassNode arrayType = BinaryExpressionMultiTypeDispatcher.getType(receiver, current);
        ClassNode arrayComponentType = arrayType.getComponentType();
        int operationType = this.getOperandType(arrayComponentType);
        BinaryExpressionWriter bew = this.binExpWriter[operationType];
        AsmClassGenerator acg = this.getController().getAcg();
        if (bew.arraySet(true)) {
            OperandStack operandStack = this.getController().getOperandStack();
            receiver.visit(acg);
            operandStack.doGroovyCast(arrayType);
            index.visit(acg);
            operandStack.doGroovyCast(ClassHelper.int_TYPE);
            rhsValueLoader.visit(acg);
            operandStack.doGroovyCast(arrayComponentType);
            bew.arraySet(false);
            operandStack.remove(3);
            rhsValueLoader.visit(acg);
        } else {
            super.assignToArray(orig, receiver, index, rhsValueLoader);
        }
    }

    protected void writePostOrPrefixMethod(int op, String method, Expression expression, Expression orig) {
        ClassNode type = BinaryExpressionMultiTypeDispatcher.getType(orig, this.getController().getClassNode());
        int operationType = this.getOperandType(type);
        BinaryExpressionWriter bew = this.binExpWriter[operationType];
        if (bew.writePostOrPrefixMethod(op, true)) {
            OperandStack operandStack = this.getController().getOperandStack();
            operandStack.doGroovyCast(type);
            bew.writePostOrPrefixMethod(op, false);
            operandStack.replace(bew.getNormalOpResultType());
        } else {
            super.writePostOrPrefixMethod(op, method, expression, orig);
        }
    }

    static {
        typeMap.put(ClassHelper.int_TYPE, 1);
        typeMap.put(ClassHelper.long_TYPE, 2);
        typeMap.put(ClassHelper.double_TYPE, 3);
        typeMap.put(ClassHelper.char_TYPE, 4);
        typeMap.put(ClassHelper.byte_TYPE, 5);
        typeMap.put(ClassHelper.short_TYPE, 6);
        typeMap.put(ClassHelper.float_TYPE, 7);
        typeMapKeyNames = new String[]{"dummy", "int", "long", "double", "char", "byte", "short", "float"};
    }

    private static class BinaryShortExpressionHelper
    extends BinaryIntExpressionHelper {
        private static final MethodCaller shortArrayGet = MethodCaller.newStatic(BytecodeInterface8.class, "sArrayGet");
        private static final MethodCaller shortArraySet = MethodCaller.newStatic(BytecodeInterface8.class, "sArraySet");

        public BinaryShortExpressionHelper(WriterController wc) {
            super(wc);
        }

        protected MethodCaller getArrayGetCaller() {
            return shortArrayGet;
        }

        protected ClassNode getArrayGetResultType() {
            return ClassHelper.short_TYPE;
        }

        protected MethodCaller getArraySetCaller() {
            return shortArraySet;
        }
    }

    private static class BinaryByteExpressionHelper
    extends BinaryIntExpressionHelper {
        private static final MethodCaller byteArrayGet = MethodCaller.newStatic(BytecodeInterface8.class, "bArrayGet");
        private static final MethodCaller byteArraySet = MethodCaller.newStatic(BytecodeInterface8.class, "bArraySet");

        public BinaryByteExpressionHelper(WriterController wc) {
            super(wc);
        }

        protected MethodCaller getArrayGetCaller() {
            return byteArrayGet;
        }

        protected ClassNode getArrayGetResultType() {
            return ClassHelper.byte_TYPE;
        }

        protected MethodCaller getArraySetCaller() {
            return byteArraySet;
        }
    }

    private static class BinaryCharExpressionHelper
    extends BinaryIntExpressionHelper {
        private static final MethodCaller charArrayGet = MethodCaller.newStatic(BytecodeInterface8.class, "cArrayGet");
        private static final MethodCaller charArraySet = MethodCaller.newStatic(BytecodeInterface8.class, "cArraySet");

        public BinaryCharExpressionHelper(WriterController wc) {
            super(wc);
        }

        protected MethodCaller getArrayGetCaller() {
            return charArrayGet;
        }

        protected ClassNode getArrayGetResultType() {
            return ClassHelper.char_TYPE;
        }

        protected MethodCaller getArraySetCaller() {
            return charArraySet;
        }
    }

    private static class DummyHelper
    extends BinaryExpressionWriter {
        public DummyHelper(WriterController controller) {
            super(controller);
        }

        public boolean writePostOrPrefixMethod(int operation, boolean simulate) {
            if (simulate) {
                return false;
            }
            throw new GroovyBugError("should not reach here");
        }

        public boolean write(int operation, boolean simulate) {
            if (simulate) {
                return false;
            }
            throw new GroovyBugError("should not reach here");
        }

        public boolean arrayGet(int operation, boolean simulate) {
            if (simulate) {
                return false;
            }
            throw new GroovyBugError("should not reach here");
        }

        public boolean arraySet(boolean simulate) {
            if (simulate) {
                return false;
            }
            throw new GroovyBugError("should not reach here");
        }

        protected void doubleTwoOperands(MethodVisitor mv) {
        }

        protected MethodCaller getArrayGetCaller() {
            return null;
        }

        protected MethodCaller getArraySetCaller() {
            return null;
        }

        protected int getBitwiseOperationBytecode(int type) {
            return -1;
        }

        protected int getCompareCode() {
            return -1;
        }

        protected ClassNode getNormalOpResultType() {
            return null;
        }

        protected int getShiftOperationBytecode(int type) {
            return -1;
        }

        protected int getStandardOperationBytecode(int type) {
            return -1;
        }

        protected void removeTwoOperands(MethodVisitor mv) {
        }

        protected void writePlusPlus(MethodVisitor mv) {
        }

        protected void writeMinusMinus(MethodVisitor mv) {
        }
    }
}

