import org.apache.commons.math.complex.*;
import org.apache.commons.math.transform.*;
import jp.crestmuse.cmx.xml.processors.*;
import jp.crestmuse.cmx.processing.*;
import jp.crestmuse.cmx.filewrappers.*;
import java.util.Properties;
import javax.mail.*;
import javax.mail.internet.*;
import javax.swing.*;
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.security.*;
import java.util.*;
import javax.activation.*;
import java.io.*;
import jp.crestmuse.cmx.elements.*;

PianoRoll Piano=new PianoRoll();
float lineWidth=210.0/12.0;

CMXController cmx = CMXController.getInstance();
PitchTrajectory Pitch;
MelodicCountor Countor;
Note Note[];
MelodyData Data=new MelodyData();
int mode=3;
Keyboard key1;
double[] index_note=new double[100];
Main ma =new Main();

FFT FFT_IFFT=new FFT();
int edit_point=0;
HMM HMM=new HMM();
MIDICreate MIDICreate = new MIDICreate();



PImage START;
PImage STOP;
PImage MELODYCHANGE;
PImage COUNTORECHANGE;

void setup(){
  background(255);
  smooth();
  size(900,700); 
  //orpheusの楽曲を用いて曲を作成する
 // String id = JOptionPane.showInputDialog(
   // this, 
   // "Orpheusで生成した楽曲のIDを入力してください。", 
    //"", JOptionPane.PLAIN_MESSAGE);
 // println(id);
  
  //プロキシ設定 必要に応じてはずす
  Properties systemSettings = System.getProperties();
  systemSettings.put("http.proxyHost", "proxy.hoge.fuga.jp");
  systemSettings.put("http.proxyPort", "8080");
  System.setProperties(systemSettings);
  
  
  Piano.Instance();
  
  //XMLファイルを読み込む
  Data.readMidiFile("tyukanhappyou");
 //Data.readmidifile("13/0549-c3bP");
  
  //情報の展開（入力されたMIDIから得る）
  Countor =Data.toMelodicCountor();
  Pitch = Data.toPitchTrajectory();
 
  //NOTE
   Note = new Note[Data.element];
   for(int a=0;a<Data.element;a++){
    Note[a] = Pitch.toNote(a,false);
   } 
  
  //初期化
  for(int i=0;i<8192;i++){
    MOUSE_P[i]=0;
  }
  
  //画像データを挿入
  STOP = loadImage("1407.png");
  START = loadImage("1415.png");
  COUNTORECHANGE = loadImage("countorchange.png");
  MELODYCHANGE = loadImage("melodychange.png");
  
}

void draw(){
  
 if(mode==1){//NOTEが初期画面
   if(cmx.isNowPlaying()){
    background(255);
    int x=(int)cmx.getTickPosition()*width/18/cmx.getTicksPerBeat();
    stroke(105,0,100); // 線の色
    strokeWeight(2);
    line(x+100,0,x+100,height);
    Countor.changemode();
    for(int a=0;a<Data.element;a++){
     Note[a].changemode();
    }
    Piano.linecalar();
    Piano.Display();
    Countor.drawing();
    for(int a=0;a<Data.element;a++){
     Note[a].display(Note[a].Front,Data.division);
    }
  }else{
    background(255);
    image(START,0,640);
    image(COUNTORECHANGE,470,630);
    
    Countor.changemode();
    
    for(int a=0;a<Data.element;a++){
     Note[a].changemode();
    }
    
    Piano.linecalar();
    Piano.Display();
    Countor.drawing();
    for(int a=0;a<Data.element;a++){
     Note[a].display(Note[a].Front,Data.division);
    }
  }
 }

 if(mode==2){//NOTEを編集しているときに通っている
  background(255);
  Countor.changemode();
  Piano.linecalar();
  Piano.Display();
  
  fill(0,0,0);
  Countor.drawing();
  
  for(int a=0;a<Data.element;a++){
   Note[a].display(Note[a].Front,Data.division);
  }
 }

 if(mode==3){//概形が前で音符が裏
  
  if(cmx.isNowPlaying()){
    background(255);
    int x=(int)cmx.getTickPosition()*width/18/cmx.getTicksPerBeat();
    stroke(105,0,100); // 線の色
    strokeWeight(2);
    line(x+100,0,x+100,height);
    Countor.changemode();
    for(int a=0;a<Data.element;a++){
     Note[a].changemode();
    }
    Countor.changemode();
    for(int a=0;a<Data.element;a++){
     Note[a].changemode();
    }
    Piano.linecalar();
    Piano.Display();
    for(int a=0;a<Data.element;a++){
     Note[a].display(Note[a].Front, Data.division);
    }
    Countor.drawing();
  }else {
    background(255);
    image(START,0,640);
    image(MELODYCHANGE,540,630);
    Piano.linecalar();
    Piano.Display();
    Countor.changemode();
     for(int a=0;a<Data.element;a++){
      Note[a].changemode();
     }
     for(int a=0;a<Data.element;a++){
      Note[a].display(Note[a].Front, Data.division);
     }
    Countor.drawing();
  }
 }

 if( mode == 4 ){
   //現在の値をコピーする
   Data.RESULTS3=FFT_IFFT.fft(Countor.timeLine,10,Data.NOTE_OFF,Data.element);//
   Data.fft_renew();//現在の値をコピーする
   Data.fftadd();
   Countor.timeLine=FFT_IFFT.ifft(Data.RESULTS2[0],Data.RESULTS2[1]);
    for(int a=0;a<Data.element;a++){
    Note[a].mousepoint();
    //println(Note[a].NOTE_NUM);
   }
    for(int a=0;a<Data.element;a++){
    //println(a+" == "+Data.NOTE_NUM[a]);
   }
   index_note=HMM.hmm(Countor.timeLine);
   Countor.timeLine=FFT_IFFT.ifft(Data.RESULTS2[0],null);
    for(int a=0;a<Data.element;a++){
    Data.renew(index_note[a],a);
    }
   Data.toPitchTrajectory();
    for(int a=0;a<Data.element;a++){
    Note[a]= Pitch.toNote(a,Note[a].note_edit);
    }
    for(int i=0;i<8192;i++){
    MOUSE_P[i]=0;
    }
   mode=3;
 }
}
double POINT_A=0;
double POINT_B=0;
int[] MOUSE_P=new int[8192];
int px2=0;
void keyPressed(){
  if(key =='h'){//key HMM確かめよう
   Countor.timeLine=FFT_IFFT.ifft(Data.RESULTS2[0],Data.RESULTS2[1]);
   Countor.timeLine=FFT_IFFT.ifft(Data.RESULTS2[0],null);

   for(int a=0;a<Data.element;a++){
   Data.renew(index_note[a],a);
   }
   Data.toPitchTrajectory();
   for(int a=0;a<Data.element;a++){
    Note[a]= Pitch.toNote(a,Note[a].note_edit);
   }
   for(int i = 0 ; i < 8192 ; i++ ){
    MOUSE_P[i]=0;
   }
  }

  if( key == 'c' ){
   Countor.timeLine=FFT_IFFT.ifft(Data.RESULTS2[0],Data.RESULTS2[1]);
  }
    if( key == 'v' ){
   Data.RESULTS2=FFT_IFFT.fft(Countor.timeLine,10,Data.NOTE_OFF,Data.element);//
   Countor.timeLine=FFT_IFFT.ifft(Data.RESULTS2[0],null);
  }
  if( key == 'u' &&  mode == 2){
    Note[edit_point].edit(1);
  }
  if( key == 'd' && mode == 2){
    Note[edit_point].edit(-1);
  }
  if( key == 'o' && mode == 2){
    Note[edit_point].target = false;
    Data.renew(Note[edit_point].NOTE_NUM,edit_point);
  
    edit_point=0;
    //println(Note[edit_point].target);
    mode=1;
  }
  if(key == '3'){

    mode = 3;
  }
  if(key == '2'){
    mode = 1 ;
  }
  if(key == '8'){
 for(int a=0;a<Data.element;a++){

    index_note[a]=Data.NOTE_NUM[a];
    println(index_note[a]);
   }
   MIDICreate.writeMIDIFILE(index_note,Data.division,Data.content,Data.element, Data.NOTE_ON, Data.NOTE_OFF);  
}

 /*if( key =='m'){
    String mailad = JOptionPane.showInputDialog(
    this, 
    "mailアドレスを入力してください。", 
    "", JOptionPane.PLAIN_MESSAGE);
  println(mailad);
    //println("送信しました");
      try{
    new Gmail().send(
            "tsuchiya@kthrlab.jp",  // gmail アカウント
            "13771377",            // gmail パスワード
            mailad,  // 送信先
            "EC2012:誰でも使える旋律編集システムを体験していただきありがとうございます",          // サブジェクト
            "さきほど作成されたMIDIファイルをお送りします。　何かご意見や質問、感想がありましたらこちらのアドレスまでお送りください。このたびは本システムを体験していただきありがとうございます。");            // 本文
          }catch(MessagingException e){
      e.printStackTrace();
    }
  
  }*/
 

}
void mousePressed(){
  if (mouseButton == LEFT){ // 左ボタンを押した
  //if(mode==3){
    //px2=0;
   //}
  if(mode==1){
    for(int a=0;a<Data.element;a++){
    Note[a].hit(a,Data.division);    
    }
  }
  if(mode==1){
   POINT_A=((pmouseX-100)*10);
  }
  if(mode==1&&cmx.isNowPlaying()==false||mode==3&&cmx.isNowPlaying()==false){
    //アイコンの当たり判定
    if(mouseX<50&&mouseX>0&&mouseY<690&&mouseY>630){
      for(int a=0;a<Data.element;a++){
       index_note[a]=Data.NOTE_NUM[a];
       //println(index_note[a]);
     }
   MIDICreate.writeMIDIFILE(index_note,Data.division,Data.content,Data.element, Data.NOTE_ON, Data.NOTE_OFF);  
   }
  }
  
  //int flag10 =0;
  if(mode==1&&cmx.isNowPlaying()==false){
    if((mouseX<900&&mouseX>470&&mouseY<690&&mouseY>630)){
      mode=3;
    }
    
  }else if(mode==3&&cmx.isNowPlaying()==false){
    if((mouseX<900&&mouseX>540&&mouseY<690&&mouseY>630)){
      mode=1;
    } 
  }
 
  }else if (mouseButton == RIGHT){ // 右ボタンを押した
    for(int a=0;a<Data.element;a++){
      if(Note[a].hitNote(a,Data.division) == true){
        Note[a].targetChange();
  }
 }
} 
  
}

  
int dragflag=0;
int flag =0;
void mouseDragged(){
  float k=0.78;
  

  if(mode==3&&cmx.isNowPlaying()==false){
    
  //if(mode==3){
    //if(px2==0){
      //px2=mouseX;
      //println("通りました");
    //}
   if(pmouseX-px2>0 && pmouseX-30>0 && px2!=0 && mouseY>0 &&mouseY<600 ){ //マウスのドラッグが枠内におさまるように
    for(int i=(px2-100)*10;i<(pmouseX-100)*10;i++){
     if(0<i&&i<8192){
     Countor.timeLine[int(i*k)] = (84.0-(mouseY)/lineWidth);
     //編集したノートのノート音の値をＭＯＵＳＥ＿Ｐの配列に突っ込むためのメソッドを利用
     
    // int insert =0;
     
     if(flag == 0){
      int insert = 0;
       for(int a = 0 ; a < Data.element ; a++ ){
        if(insert == 0){
        insert = Note[a].find(int(i*k));
        }
       }
     //println(insert+" "+int(i*k) );
      for(int a=insert;a<=int(i*k);a++){
      MOUSE_P[a]=1;
      //println("とおりました"+a);
      }
      flag=1;
    }
     
     MOUSE_P[int(i*k)]=1;
     //MOUSE_P[insert]=1;
     dragflag=1;
     }
    }
   }
   px2=pmouseX;
  }
    if(mode==2){ //編集モードでノートがクリックされたとき
    //println(Note[10].target);
    for(int a=0;a<Note.length;a++){
     if(Note[a].target == true && Note[a].note_edit == true){
     for(int b=0;b<Data.element;b++){
      if(Note[b].target_mark()){
       Note[b].edit2(mouseY);
       }   
     } 
   }
  } 
 }
}
void mouseReleased(){
 if( mouseX<=900 && mouseX>=0 && mouseY<=630 && mouseY>=0){
  if(mode==3&&dragflag==1){
    px2=0;
    mode=4;
    dragflag=0;
    flag=0;
    
   println("通りました");
  }
 }
  if(mode==2){
    Note[edit_point].target = false;
    Data.renew(Note[edit_point].NOTE_NUM,edit_point);
    edit_point=0;
    //println(Note[edit_point].target);
    mode=1;
  }
}


String TEMPFILE;
public class Gmail{
    private final Properties PROP;
    Gmail(){
        PROP = new Properties();
        PROP.put("mail.smtp.host", "smtp.gmail.com");
        PROP.put("mail.smtp.port", "587");
        PROP.put("mail.smtp.auth", "true");
        PROP.put("mail.smtp.starttls.enable", "true");
    }
 

    public void send(
        String user,
        String password,
        String to,
        String subject,
        String body) throws MessagingException {
        Transport transport = null;
        try {
            Session sess = Session.getInstance(PROP);
            MimeMessage mm = new MimeMessage(sess);
            mm.setFrom(new InternetAddress(user));
            mm.setSubject(subject);
            mm.setRecipient(
            Message.RecipientType.TO, new InternetAddress(to));
            
            //本文パート作成
            MimeBodyPart main =new MimeBodyPart();
            main.setText(body, "ISO-2022-JP");
      //      main.setText(body, "text/plain; charset=iso-2022-jp");
            
            //添付ファイルパート
            MimeBodyPart tempfile =new MimeBodyPart();
            String filename="C:\\processing-1.5.1-windows\\processing-1.5.1\\"+TEMPFILE+"";
            FileDataSource file = new FileDataSource(filename);
            tempfile.setDataHandler(new DataHandler(file));
            tempfile.setFileName(TEMPFILE);
            
            //マルチパートにBodyパート２つを挿入
            Multipart mp = new MimeMultipart();
            mp.addBodyPart(main);
            mp.addBodyPart(tempfile);
            
            //
            mm.setContent(mp);
            

            //println("通りました");
            //mm.setContent(body, "text/plain; charset=iso-2022-jp");
            //mm.setHeader("Content-Transfer-Encoding", "7bit");
            transport = sess.getTransport("smtp");
            transport.connect(user, password);
            transport.sendMessage(mm, mm.getAllRecipients());
             } catch (Exception e) {
          e.printStackTrace();
        }
        finally {
            if (transport != null) {
                transport.close();
            }
        }
    }
}


