import org.apache.commons.math.complex.*;
import org.apache.commons.math.transform.*;
import jp.crestmuse.cmx.xml.processors.*;
import jp.crestmuse.cmx.processing.*;
import jp.crestmuse.cmx.filewrappers.*;

  double[] timeline=new double[8192];
  Complex[][] results2=new Complex[2][];
  Complex[][] results3=new Complex[2][]; 

  double[] note_on= new double[8192];//ノートON
  double[] note_off=new double[8192];
  double[] note_num= new double[8192];
  
  int element;
  
  double[] distance= new double[300];
  
  int order = 10;
  
  int mode=0;
  
  
  int division;
  
  String con;
  
  int px2=0;

void setup(){
  background(255);
  smooth();
  size(530,300);
  value();
  String filename="shinsample";
  timeline=readmidifile(filename);
  results2=fft(timeline,order);
  results3=fft(timeline,order);
  timeline=ifft(results2[0],null);//timelineに挿入する
}

void draw(){
  if(mode==0){//描画
  drawing_drawEnvelope(timeline);
  }
  else if(mode==1){ //mouseイベントを組み合わせて編集作業
  background(255);
  //edit(timeline,index_point,add_2);
  results3=fft(timeline,order);
  results2[0]=results3[0];
  timeline=ifft(results2[0],null);
  mode=0;
 }
 else if(mode==2){//高い周波数と合わせる;
 background(255);
 timeline=ifft(results3[0],results2[1]);
 mode=0;
 }
 else if(mode==3){
   midiwritefile(timeline);
   mode=0;
 }
}

void drawing_drawEnvelope(double timeline2[]){
  value();
  float k=8192.0/7680.0;
  double[] timeline3=new double[8192];
  for(int a=0;a<8192;a++){//描画//
    timeline3[a]=295-((timeline2[a]-22)*10);
  }
  for(int b=1;b<7680;b++){
    line(20+(b/16)*k,(int)timeline3[b],20+((b-1)/16)*k,(int)timeline3[b-1]);//8000だと大きくなってしまうから3分の１サイズ//
 }
}

Complex[][] fft(double timeline[] ,int k){
  
  Complex[][] results = new Complex[2][];
  timeline=averageinsert(timeline);//平均値を代入
  
  FastFourierTransformer abc=new FastFourierTransformer();//フーリエ変換//
  results[0]=abc.transform(timeline);
  results[1]=abc.transform(timeline);
 for( int a=k;a<8192-k;a++){//高次の係数をゼロにする。//
    results[0][a]=new Complex(0,0);
 }
 for(int a=0;a<k;a++){//低い係数を０にしたものを残す。 
   results[1][a]=new Complex(0,0);//配列の配列の回しかたがよくわからない。
 }
 for(int a=8192-k;a<8192;a++){
   results[1][a]=new Complex(0,0);
 }
 return results; 
}

double[] averageinsert(double average[]){
  int addValue=0;
  for(int a=0;a<note_off[element-1];a++){
    addValue+=average[a];
  }
  addValue=addValue/(int)note_off[element-1];
  for(int a=(int)note_off[element-1];a<8192;a++){
    average[a]=addValue;
  }
  //println(average);
  return average;
  
}

 double[] readmidifile(String filename){
  double[] timeline=new double[8192];
 
   CMXController cmx = CMXController.getInstance();
   SCCXMLWrapper sccxml =(SCCXMLWrapper)cmx.read(createInput(filename+".xml"));
    try{
     SCCXMLWrapper.Part[] partlist=sccxml.getPartList();
     division=sccxml.getDivision();
     SCCXMLWrapper.HeaderElement[] header=sccxml.getHeaderElementList();
     con=header[0].content();
   
      for(int a = 0;a<partlist.length ; a++){
       SCCXMLWrapper.Note[] notelist=partlist[a].getNoteList();
       element=notelist.length;
       for(int b = 0 ;b < element;b++){
        note_on[b]=notelist[b].onset();
        note_off[b]=notelist[b].offset();
        note_num[b]=notelist[b].notenum();
       }
     }
     timeline=abc(note_on,note_num,element,note_off);
     return timeline;
}
  catch( javax.xml.transform.TransformerException e )
  {
    println("xmlファイルが正しくありません。");
    throw new IllegalArgumentException
    ("XMLファイルを読み込ませてください");
 }
}

double[] abc(double[] note_on1,double[]  note_num1, int element2,double[] note_off1){//ノートナンバーを分けるための関数
  double[] time_line_copy= new double[8192];
  int n=note_on.length;
  double[] noteon_copy=new double[n];
  for(int i=0;i<n;i++){
    noteon_copy[i]=note_on1[i];
  } 
  for(int i=0;i<8192;i++){
    time_line_copy[i]=0;
  }
  for(int i=1;i<element;i++){
    while(noteon_copy[i-1]<noteon_copy[i]){
      time_line_copy[(int)noteon_copy[i-1]]=note_num1[i-1];
      noteon_copy[i-1]+=1;
    }
  }
  for(int i=(int)noteon_copy[element-1];i<note_off1[element-1];i++){
    time_line_copy[i]=note_num1[element-1];
  }
     return time_line_copy;
}

double[] ifft(Complex higher[],Complex lower[]){
  FastFourierTransformer abc=new FastFourierTransformer();
  Complex[] test=new Complex[8192];
  Complex[] ifft=new Complex[8192];
  double[] ifft2=new double[8192];
  
  if( higher == null ){
    ifft=abc.inversetransform(lower);
    for(int a=0;a<8192;a++){
      ifft2[a]=ifft[a].getReal();
    }
    return ifft2;
  }else if(lower==null){
  ifft=abc.inversetransform(higher);
    for(int a=0;a<8192;a++){
      ifft2[a]=ifft[a].getReal();
    }
    return ifft2;
  }else{   
    for(int a=0;a<8192;a++){//結合
    test[a]=lower[a].add(higher[a]);
  }
  ifft=abc.inversetransform(test);
  for(int a=0;a<8192;a++){
    ifft2[a]=ifft[a].getReal();
  }
  return ifft2;
  }
}

void value(){
   int b=22;
  for(int a=0;a<30;a++){
      fill(15);
    text(b+" ",0,300-a*10);
    b++;
  }
}

void mousePressed(){
}

void mouseDragged(){
  int k=0;
  line(pmouseX,pmouseY,mouseX,mouseY);
  
  println((px2-30)*15-(pmouseX-30)*15);
  
  if(pmouseX-px2>0 && pmouseX-30>0 && px2!=0){
    
  for(int i=(px2-30)*15;i<(pmouseX-30)*15;i++){//前のpmouseXから今のPmouseXの間まで
    timeline[i]=(300-mouseY)/10+22;
    //index_point++;
  }
}

px2=pmouseX;
}

void mouseReleased(){
  px2=0;
  mode=1;
  for(int k=1000;k<2000;k++){
    print(k+" ");
    println(timeline[k]);
  }
}


void keyPressed(){
  if(key=='1'){
    mode=2;
  }
  if(key=='2'){
    mode=3;
  }
  
}

double[] edit(double timeline[],int index,int add){
  int k=80;
  for(int a=index;a<index+k;a++){
    timeline[a]+=add;
  }
  return timeline;
}

void midiwritefile(double[] note_on_date){
  
  double[] index_notenum=new double[8192];
  
  double[][] note_num_copy=new double[element][8192];
  
  CMXController cmx = CMXController.getInstance();
  SCCXMLWrapper scc = (SCCXMLWrapper)cmx.createDocument(SCCXMLWrapper.TOP_TAG);
  scc.setDivision(division);
  scc.beginHeader();
  scc.addHeaderElement(0, "TEMPO", con);
  scc.endHeader();
  scc.newPart(1, 1, 0, 100);
  
  double[] ave;
  double[] bunpu=new double[30];
  
  for(int i=0;i<30;i++){
    bunpu[i]=i+22;
  }
  
  
  double[][] atai=new double[element][30];
  
  double[] standard_divition;
  
  ave=heikin(note_on_date);
  standard_divition=hyoujun(ave,note_on_date);
  atai=samp(ave,standard_divition,bunpu);
  index_notenum=simi(atai);  
  
  for(int i=0;i<index_notenum.length;i++){
    println(index_notenum[i]);
  }
  
  
  for(int a=0;a<element;a++){
  scc.addNoteElement((int)note_on[a], (int)note_off[a], (int)index_notenum[a], 100);
  }
  println("作成完了しました");
  scc.endPart();
  try{
   scc.writefile("tsuchiya_hensyu3.xml");
   scc.finalizeDocument();
  cmx.smfread(scc);
  cmx.playMusic();
    }catch(java.io.IOException e){
     }catch(org.xml.sax.SAXException e){
  }
}

double[] simi(double[][] sampuzu){
  int hensu=0;
  double c=0.4;
  double g=0.25;
  double f=0.13;
  double e=0.1;
  double d=0.07;
  double a=0.04;
  double oth=0.001;
//  double oth=0.01;
  double[] index_date=new double[element];
  double max=0;
  println(element);
  
  for(int i=0;i<element;i++){
    for(int v=0;v<30;v++){//音楽要素含んだ確率を１つずつ出す
      if(v==2||v==14||v==26){//Cの時
       sampuzu[i][v]=sampuzu[i][v]*c;
      }
      else if(v==21||v==9){//G
      sampuzu[i][v]=sampuzu[i][v]*g;
      }
      else if(v==7||v==19){//f
      sampuzu[i][v]=sampuzu[i][v]*f;
      }
      else if(v==6||v==18){//e
      sampuzu[i][v]=sampuzu[i][v]*e;
      }
      else if(v==4||v==16){//d
      sampuzu[i][v]=sampuzu[i][v]*d;
      }
      else if(v==11||v==23){//a
      sampuzu[i][v]=sampuzu[i][v]*a;
      }
      else{
        sampuzu[i][v]=sampuzu[i][v]*oth;//そのた
      }
      
  }
 }
  
  for(int y=0;y<element;y++){//各要素の最大値を出す
   for(int k=0;k<30;k++){
     if(sampuzu[y][k]>max){
       max=sampuzu[y][k];
       index_date[y]=k+22;
     }
   }
   max=0;
  }
  return index_date;
}


double[][] samp(double[] average,double[] standard_divition,double[] element2){
  double sample=0;
  double sample2=0;
  double[][]  sample3=new double[element][30];//散布図作成の手順
  for(int a=0;a<element;a++){
   for(int i=0;i<30;i++){
  sample=1/Math.sqrt((2*PI*Math.pow(standard_divition[a],2)));
  sample2=Math.exp(-(Math.pow((element2[i]-average[a]),2)) / (2 * Math.pow(standard_divition[a],2)));
  sample3[a][i]=sample*sample2;
  }
 }
  
  println(sample3[4][12]);
  return sample3;
}



double[] hyoujun(double[] heikin,double[] element2){
  double[] answer=new double[element];
  double variation=0;
  double sum2=0;
  int k=0;//要素数
  
     int n=note_on.length;     //ノートONとoffのcopyをとる所
  double[] noteon_copy=new double[n];
  double[] noteoff_copy=new double[n];
  for(int i=0;i<n;i++){
    noteon_copy[i]=note_on[i];
    noteoff_copy[i]=note_off[i];
  }
  

  for(int v=0;v<element;v++){
    if(noteon_copy[v+1]>noteoff_copy[v]||v==element-1){
    for(int i=(int)noteon_copy[v];i<(int)noteoff_copy[v];i++){//まず分散を出す
  variation=heikin[v]-element2[i];//偏差
  sum2+=Math.pow(variation,2);
  k++;
  }
  sum2=sum2/k; //分散を出す
  k=0;//分散を０にする
  answer[v]=Math.sqrt(sum2);//標準偏差＝分散の平方根
  sum2=0;//合計を０にする
  }
  else{
    for(int i=(int)noteon_copy[v];i<(int)noteon_copy[v+1];i++){
       variation=heikin[v]-element2[i];//偏差
  sum2+=Math.pow(variation,2);
  k++;
    }  
  sum2=sum2/k; //分散を出す
  k=0;//分散を０にする
  answer[v]=Math.sqrt(sum2);//標準偏差＝分散の平方根
  sum2=0;//合計を０にする
   }
  }
 println("標準偏差は"+answer[3]);
  return answer;
  
}


double[] heikin(double[] d){
  double k=0;
  double[] sum=new double[element];
  double[] ans=new double[element];
    int n=note_on.length;     //copyをとる所
  double[] noteon_copy=new double[n];
  double[] noteoff_copy=new double[n];
  for(int i=0;i<n;i++){
    noteon_copy[i]=note_on[i];
    noteoff_copy[i]=note_off[i];
  }
 
  
  
  for(int x=0;x<element;x++){
    if(noteon_copy[x+1]>noteoff_copy[x]||x==element-1){
  for(int i=(int)noteon_copy[x];i<(int)noteoff_copy[x];i++){
    sum[x]+=d[i];
  }
  k=noteoff_copy[x]-noteon_copy[x];
  sum[x]=sum[x]/k;
 }
else{
  for(int y=(int)noteon_copy[x];y<(int)noteon_copy[x+1];y++){
    sum[x]+=d[y];
  }
   k=noteon_copy[x+1]-noteon_copy[x];
   sum[x]=sum[x]/k;
 }
}

  for(int i=0;i<sum.length;i++){//四捨五入
    sum[i]+=0.5;
    println(sum[i]);
    sum[i]=(int)sum[i];
  }
  println("平均は"+sum[3]);
  return sum;
}

